/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.base.vo.PaginationVO;
import com.shuxi.bean.dto.InternetOfEverythingCropDemandDto;
import com.shuxi.bean.dto.InternetOfEverythingCropEvapotranspirationDto;
import com.shuxi.bean.vo.ChartVo;
import com.shuxi.bean.vo.DeviceVo;
import com.shuxi.bean.vo.DiseaseInsectWarningVo;
import com.shuxi.bean.vo.InternetOfEverythingChartVo;
import com.shuxi.bean.vo.InternetOfEverythingChartYDataVo;
import com.shuxi.bean.vo.InternetOfEverythingCropMonitoringVo;
import com.shuxi.bean.vo.InternetOfEverythingMapFacilityVo;
import com.shuxi.bean.vo.InternetOfEverythingMapVo;
import com.shuxi.bean.vo.InternetOfEverythingRainfallVo;
import com.shuxi.bean.vo.IrrigationModelChartVo;
import com.shuxi.bean.vo.IrrigationModelDataVo;
import com.shuxi.bean.vo.IrrigationModelVo;
import com.shuxi.bean.vo.PestCountChartVo;
import com.shuxi.bean.vo.PestCountVo;
import com.shuxi.bean.vo.PestDataChartVo;
import com.shuxi.bean.vo.PestDetectionImgVo;
import com.shuxi.bean.vo.SoilDetailChartDataVo;
import com.shuxi.bean.vo.SoilDetailChartVo;
import com.shuxi.bean.vo.SoilTemperatureHumidityVo;
import com.shuxi.bean.vo.SoilWaringLineVo;
import com.shuxi.bean.vo.WeatherStationDataVo;
import com.shuxi.mapper.InternetOfEverythingDpMapper;
import com.shuxi.service.InternetOfEverythingDpService;
import com.shuxi.util.DataException;
import com.shuxi.util.DateUtils;
import com.shuxi.util.JsonUtil;
import com.shuxi.util.StringUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InternetOfEverythingDpServiceImpl
implements InternetOfEverythingDpService {
    private static final Logger log = LoggerFactory.getLogger(InternetOfEverythingDpServiceImpl.class);
    private final InternetOfEverythingDpMapper internetOfEverythingDpMapper;

    public List<Map<String, Object>> farmRecord(Integer companyId) {
        try {
            String line;
            URL url = new URL("http://pc.shuxitech.com/api/farm_server/view/temp/querySystemData");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/json");
            String postParams = "{\n  \"companyId\": \"" + companyId + "\",\n  \"userId\": \"9918A41AFECA9F4F06DB06B1FD72FB82\",\n  \"moduleKey\": \"farmingRecord\",\n  \"case\": {\n    \"pageNo\": 1,\n    \"pageSize\": 50\n  }\n}";
            DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());
            outputStream.writeBytes(postParams);
            outputStream.flush();
            outputStream.close();
            InputStream inputStream = conn.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
            }
            reader.close();
            Map map = (Map)JsonUtil.getJsonToBean((String)stringBuilder.toString(), Map.class);
            Map resDataMap = (Map)map.get("resData");
            List dataList = (List)resDataMap.get("data");
            return dataList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public SoilDetailChartVo querySoilDetail(String startTime, String endTime, Integer dateType, String deviceId, Integer companyId) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startDate = format.parse(startTime);
            Date endDate = format.parse(endTime);
            SimpleDateFormat ft = null;
            SoilDetailChartVo chartVo = new SoilDetailChartVo();
            ArrayList legendData = Lists.newArrayList();
            legendData.add("\u9884\u8b66\u7ebf");
            legendData.add("20cm");
            legendData.add("40cm");
            legendData.add("60cm");
            legendData.add("80cm");
            chartVo.setLegendData((List)legendData);
            ArrayList xData = Lists.newArrayList();
            ArrayList yData = Lists.newArrayList();
            ArrayList yLeftData20 = Lists.newArrayList();
            ArrayList yLeftData40 = Lists.newArrayList();
            ArrayList yLeftData60 = Lists.newArrayList();
            ArrayList yLeftData80 = Lists.newArrayList();
            ArrayList yRightData = Lists.newArrayList();
            if (StringUtil.isNotEmpty((String)deviceId)) {
                List list = Lists.newArrayList();
                if (dateType == 1) {
                    ft = new SimpleDateFormat("yyyy-MM-dd");
                    list = this.internetOfEverythingDpMapper.querySoilTemperatureHumidityDate(startDate, endDate, deviceId, companyId);
                } else {
                    ft = new SimpleDateFormat("HH:mm");
                    list = this.internetOfEverythingDpMapper.querySoilTemperatureHumidityByTime(startDate, endDate, deviceId, companyId);
                }
                if (StringUtil.isNotEmpty((Collection)list)) {
                    List<Object> dateList = Lists.newArrayList();
                    if (dateType == 1) {
                        dateList = list.stream().map(t -> t.getUpTime()).distinct().collect(Collectors.toList());
                        xData.addAll(dateList);
                    } else {
                        list.stream().forEach(t -> {
                            String upTime = t.getUpTime() + ":00";
                            t.setUpTime(upTime);
                        });
                        List timeList = list.stream().map(SoilTemperatureHumidityVo::getUpTime).collect(Collectors.toList());
                        xData.addAll(timeList);
                    }
                    for (String str : xData) {
                        List<Object> humidity20List = Lists.newArrayList();
                        List<Object> humidity40List = Lists.newArrayList();
                        List<Object> humidity60List = Lists.newArrayList();
                        List<Object> humidity80List = Lists.newArrayList();
                        List<Object> temperatureList = Lists.newArrayList();
                        humidity20List = list.stream().filter(t -> str.equals(t.getUpTime())).map(t -> t.getSoilWaterContent20().toString()).collect(Collectors.toList());
                        if (StringUtil.isNotEmpty((Collection)humidity20List)) {
                            yLeftData20.add(humidity20List.get(0));
                        }
                        if (StringUtil.isNotEmpty((Collection)(humidity40List = list.stream().filter(t -> str.equals(t.getUpTime())).map(t -> t.getSoilWaterContent40().toString()).collect(Collectors.toList())))) {
                            yLeftData40.add(humidity40List.get(0));
                        }
                        if (StringUtil.isNotEmpty((Collection)(humidity60List = list.stream().filter(t -> str.equals(t.getUpTime())).map(t -> t.getSoilWaterContent60().toString()).collect(Collectors.toList())))) {
                            yLeftData60.add(humidity60List.get(0));
                        }
                        if (StringUtil.isNotEmpty((Collection)(humidity80List = list.stream().filter(t -> str.equals(t.getUpTime())).map(t -> t.getSoilWaterContent80().toString()).collect(Collectors.toList())))) {
                            yLeftData80.add(humidity80List.get(0));
                        }
                        if (!StringUtil.isNotEmpty((Collection)(temperatureList = list.stream().filter(t -> str.equals(t.getUpTime())).map(t -> t.getSoilTemp().toString()).collect(Collectors.toList())))) continue;
                        yRightData.add(temperatureList.get(0));
                    }
                }
            }
            SoilDetailChartDataVo data20Vo = new SoilDetailChartDataVo();
            data20Vo.setName("20cm");
            data20Vo.setLeftData((List)yLeftData20);
            data20Vo.setRightData((List)yRightData);
            yData.add(data20Vo);
            SoilDetailChartDataVo data40Vo = new SoilDetailChartDataVo();
            data40Vo.setName("40cm");
            data40Vo.setLeftData((List)yLeftData40);
            data40Vo.setRightData((List)yRightData);
            yData.add(data40Vo);
            SoilDetailChartDataVo data60Vo = new SoilDetailChartDataVo();
            data60Vo.setName("60cm");
            data60Vo.setLeftData((List)yLeftData60);
            data60Vo.setRightData((List)yRightData);
            yData.add(data60Vo);
            SoilDetailChartDataVo data80Vo = new SoilDetailChartDataVo();
            data80Vo.setName("80cm");
            data80Vo.setLeftData((List)yLeftData80);
            data80Vo.setRightData((List)yRightData);
            yData.add(data80Vo);
            SimpleDateFormat yearFt = new SimpleDateFormat("yyyy");
            SimpleDateFormat motherFt = new SimpleDateFormat("MM");
            SimpleDateFormat dayFt = new SimpleDateFormat("dd");
            int startYear = Integer.parseInt(yearFt.format(startDate));
            int startMother = Integer.parseInt(motherFt.format(startDate));
            int startDay = Integer.parseInt(dayFt.format(startDate));
            LocalDate localStartDate = LocalDate.of(startYear, startMother, startDay);
            int startDayOfYear = localStartDate.get(ChronoField.DAY_OF_YEAR);
            int endYear = Integer.parseInt(yearFt.format(endDate));
            int endMother = Integer.parseInt(motherFt.format(endDate));
            int endDay = Integer.parseInt(dayFt.format(endDate));
            LocalDate localEndDate = LocalDate.of(endYear, endMother, endDay);
            int endDayOfYear = localEndDate.get(ChronoField.DAY_OF_YEAR);
            List waringLineVoList = this.internetOfEverythingDpMapper.querySoilWaringLineList(startDayOfYear, endDayOfYear, companyId);
            ArrayList waringLineData = Lists.newArrayList();
            for (String str : xData) {
                if (dateType == 1) {
                    Date date = ft.parse(str);
                    int year = Integer.parseInt(yearFt.format(date));
                    int mother = Integer.parseInt(motherFt.format(date));
                    int day = Integer.parseInt(dayFt.format(date));
                    LocalDate localDate = LocalDate.of(year, mother, day);
                    int dayOfYear = localDate.get(ChronoField.DAY_OF_YEAR);
                    List filterList = waringLineVoList.stream().filter(t -> t.getDoy() == dayOfYear).collect(Collectors.toList());
                    if (!StringUtil.isNotEmpty(filterList)) continue;
                    waringLineData.add(((SoilWaringLineVo)filterList.get(0)).getSoilMoiWarningLine().toString());
                    continue;
                }
                waringLineData.add(((SoilWaringLineVo)waringLineVoList.get(0)).getSoilMoiWarningLine().toString());
            }
            chartVo.setWaringLineData((List)waringLineData);
            chartVo.setXData((List)xData);
            chartVo.setLegendData((List)legendData);
            chartVo.setYData((List)yData);
            return chartVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e07\u7269\u4e92\u8054-\u83b7\u53d6\u571f\u58e4\u6e29\u6e7f\u5ea6\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
            throw new DataException("\u4e07\u7269\u4e92\u8054-\u83b7\u53d6\u571f\u58e4\u6e29\u6e7f\u5ea6\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public WeatherStationDataVo queryWeatherStationInformation(Integer companyId) {
        try {
            WeatherStationDataVo dataVo = new WeatherStationDataVo();
            List list = this.internetOfEverythingDpMapper.queryWeatherStationInformation(companyId);
            if (StringUtil.isNotEmpty((Collection)list)) {
                dataVo = (WeatherStationDataVo)JsonUtil.getJsonToBean(list.get(0), WeatherStationDataVo.class);
            }
            return dataVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e07\u7269\u4e92\u8054-\u6c14\u8c61\u7ad9\u5b9e\u65f6\u6570\u636e\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
            throw new DataException("\u4e07\u7269\u4e92\u8054-\u6c14\u8c61\u7ad9\u5b9e\u65f6\u6570\u636e\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public IrrigationModelDataVo queryIrrigationModel(Integer companyId) {
        try {
            IrrigationModelDataVo modelDataVo = new IrrigationModelDataVo();
            ArrayList xData = Lists.newArrayList();
            ArrayList legendData = Lists.newArrayList();
            ArrayList yDatas = Lists.newArrayList();
            legendData.add("\u6c34\u4f4d\u7ba1\u7406\u76ee\u6807");
            legendData.add("\u964d\u6c34");
            legendData.add("\u704c\u6e89\u91cf");
            legendData.add("\u6392\u6c34\u91cf");
            legendData.add("\u6e17\u6f0f\u91cf");
            IrrigationModelVo dataVo = this.internetOfEverythingDpMapper.queryIrrigationModel(companyId);
            if (ObjectUtil.isNull((Object)dataVo)) {
                return modelDataVo;
            }
            String[] waterDepletion = dataVo.getWaterTarget().replace("{", "").replace("}", "").split(",");
            IrrigationModelChartVo waterDepletionVo = new IrrigationModelChartVo();
            waterDepletionVo.setName("\u6c34\u4f4d\u7ba1\u7406\u76ee\u6807");
            waterDepletionVo.setYData(Arrays.asList(waterDepletion));
            yDatas.add(waterDepletionVo);
            Integer length = waterDepletion.length;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String startDate = format.format(dataVo.getStartDate());
            LocalDate date = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            for (int i = 0; i < length; ++i) {
                date = date.plusDays(1L);
                String dateStr = date.format(df);
                xData.add(dateStr);
            }
            String[] irrigation = dataVo.getIrrigation().replace("{", "").replace("}", "").split(",");
            IrrigationModelChartVo warningLineVo = new IrrigationModelChartVo();
            warningLineVo.setName("\u704c\u6e89\u91cf");
            warningLineVo.setYData(Arrays.asList(irrigation));
            yDatas.add(warningLineVo);
            String[] rain = dataVo.getRain().replace("{", "").replace("}", "").split(",");
            IrrigationModelChartVo rainVo = new IrrigationModelChartVo();
            rainVo.setName("\u964d\u6c34");
            rainVo.setYData(Arrays.asList(rain));
            yDatas.add(rainVo);
            String[] drainage = dataVo.getDrainage().replace("{", "").replace("}", "").split(",");
            IrrigationModelChartVo irrigationModelChartVo = new IrrigationModelChartVo();
            irrigationModelChartVo.setName("\u6392\u6c34\u91cf");
            irrigationModelChartVo.setYData(Arrays.asList(drainage));
            yDatas.add(irrigationModelChartVo);
            String[] percolation = dataVo.getPercolation().replace("{", "").replace("}", "").split(",");
            IrrigationModelChartVo percolationChartVo = new IrrigationModelChartVo();
            percolationChartVo.setName("\u6e17\u6f0f\u91cf");
            percolationChartVo.setYData(Arrays.asList(percolation));
            yDatas.add(percolationChartVo);
            modelDataVo.setXData((List)xData);
            modelDataVo.setYDatas((List)yDatas);
            modelDataVo.setLegendData((List)legendData);
            return modelDataVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e07\u7269\u4e92\u8054-\u704c\u6e89\u6a21\u578b\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
            throw new DataException("\u4e07\u7269\u4e92\u8054-\u704c\u6e89\u6a21\u578b\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public InternetOfEverythingChartVo queryRainfall(Integer companyId) {
        Integer oldYear = DateUtils.dateAddYearsToInteger((Date)new Date(), (int)-3, (String)"yyyy");
        List internetOfEverythingRainfallList = this.internetOfEverythingDpMapper.queryRainfall(oldYear, companyId);
        List yearList = internetOfEverythingRainfallList.stream().map(t -> String.valueOf(t.getYear())).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        String nowYear = DateUtils.getNowYearToString();
        Integer nowMonth = DateUtils.getNowMonth();
        String forecastYear = nowYear + "\u9884\u6d4b\u96e8\u91cf";
        yearList.add(forecastYear);
        List monthList = internetOfEverythingRainfallList.stream().map(t -> String.valueOf(t.getMonth()) + "\u6708").collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        InternetOfEverythingChartVo internetOfEverythingChartVo = new InternetOfEverythingChartVo();
        ArrayList<InternetOfEverythingChartYDataVo> internetOfEverythingRainfallYDataList = new ArrayList<InternetOfEverythingChartYDataVo>();
        for (int i = 0; i < yearList.size(); ++i) {
            String year = (String)yearList.get(i);
            InternetOfEverythingChartYDataVo internetOfEverythingChartYDataVo = new InternetOfEverythingChartYDataVo();
            internetOfEverythingChartYDataVo.setName(String.valueOf(year));
            ArrayList<String> yData = new ArrayList<String>();
            for (InternetOfEverythingRainfallVo internetOfEverythingRainfallVo : internetOfEverythingRainfallList) {
                if (i < yearList.size() - 2 && year.equals(String.valueOf(internetOfEverythingRainfallVo.getYear()))) {
                    yData.add(internetOfEverythingRainfallVo.getRain());
                }
                if (i == yearList.size() - 2 && year.equals(String.valueOf(internetOfEverythingRainfallVo.getYear())) && internetOfEverythingRainfallVo.getMonth() <= nowMonth) {
                    yData.add(internetOfEverythingRainfallVo.getRain());
                }
                if (i != yearList.size() - 1) continue;
                if (nowYear.equals(String.valueOf(internetOfEverythingRainfallVo.getYear())) && internetOfEverythingRainfallVo.getMonth() <= nowMonth) {
                    yData.add("0");
                }
                if (!nowYear.equals(String.valueOf(internetOfEverythingRainfallVo.getYear())) || internetOfEverythingRainfallVo.getMonth() <= nowMonth) continue;
                yData.add(internetOfEverythingRainfallVo.getRain());
            }
            internetOfEverythingChartYDataVo.setYData(yData);
            internetOfEverythingRainfallYDataList.add(internetOfEverythingChartYDataVo);
        }
        internetOfEverythingChartVo.setLegendData(yearList);
        internetOfEverythingChartVo.setXData(monthList);
        internetOfEverythingChartVo.setYDatas(internetOfEverythingRainfallYDataList);
        return internetOfEverythingChartVo;
    }

    public InternetOfEverythingChartVo queryAtmosphere(String startTime, String endTime, Integer dateType, Integer humitureType, Integer companyId) {
        InternetOfEverythingChartVo internetOfEverythingChartVo = new InternetOfEverythingChartVo();
        Timestamp startTimestamp = Timestamp.valueOf(startTime);
        Timestamp endTimestamp = Timestamp.valueOf(endTime);
        ArrayList internetOfEverythingRainfallYDataList = new ArrayList();
        if (1 == dateType) {
            this.setPolylineChartByDate(internetOfEverythingChartVo, internetOfEverythingRainfallYDataList, startTimestamp, endTimestamp, humitureType, companyId);
        }
        if (2 == dateType) {
            this.setPolylineChartByTime(internetOfEverythingChartVo, internetOfEverythingRainfallYDataList, startTimestamp, endTimestamp, humitureType, companyId);
        }
        return internetOfEverythingChartVo;
    }

    private void setPolylineChartByDate(InternetOfEverythingChartVo internetOfEverythingChartVo, List<InternetOfEverythingChartYDataVo> internetOfEverythingRainfallYDataList, Timestamp startTimestamp, Timestamp endTimestamp, Integer humitureType, Integer companyId) {
        InternetOfEverythingChartYDataVo internetOfEverythingRainfallYData;
        List<String> temperatureTypes = Arrays.asList("\u6700\u9ad8\u6e29\u5ea6", "\u6700\u4f4e\u6e29\u5ea6", "\u5e73\u5747\u6e29\u5ea6");
        List<String> humidnessTypes = Arrays.asList("\u6700\u9ad8\u6e7f\u5ea6", "\u6700\u4f4e\u6e7f\u5ea6", "\u5e73\u5747\u6e7f\u5ea6");
        String datePattern = "MM/dd";
        List internetOfEverythingAtmosphereList = this.internetOfEverythingDpMapper.queryAtmosphereByDate(startTimestamp, endTimestamp, humitureType, companyId);
        List dateList = internetOfEverythingAtmosphereList.stream().map(t -> DateUtils.dateToString((Date)t.getDateTime(), (String)datePattern)).collect(Collectors.toList());
        List maxDatas = internetOfEverythingAtmosphereList.stream().map(t -> t.getMaxData()).collect(Collectors.toList());
        List minDatas = internetOfEverythingAtmosphereList.stream().map(t -> t.getMinData()).collect(Collectors.toList());
        List avgDatas = internetOfEverythingAtmosphereList.stream().map(t -> t.getAvgData()).collect(Collectors.toList());
        if (1 == humitureType) {
            for (String temperatureType : temperatureTypes) {
                internetOfEverythingRainfallYData = new InternetOfEverythingChartYDataVo();
                if ("\u6700\u9ad8\u6e29\u5ea6".equals(temperatureType)) {
                    internetOfEverythingRainfallYData.setName("\u6700\u9ad8\u6e29\u5ea6");
                    internetOfEverythingRainfallYData.setYData(maxDatas);
                }
                if ("\u6700\u4f4e\u6e29\u5ea6".equals(temperatureType)) {
                    internetOfEverythingRainfallYData.setName("\u6700\u4f4e\u6e29\u5ea6");
                    internetOfEverythingRainfallYData.setYData(minDatas);
                }
                if ("\u5e73\u5747\u6e29\u5ea6".equals(temperatureType)) {
                    internetOfEverythingRainfallYData.setName("\u5e73\u5747\u6e29\u5ea6");
                    internetOfEverythingRainfallYData.setYData(avgDatas);
                }
                internetOfEverythingRainfallYDataList.add(internetOfEverythingRainfallYData);
            }
            internetOfEverythingChartVo.setLegendData(temperatureTypes);
        }
        if (2 == humitureType) {
            for (String humidnessType : humidnessTypes) {
                internetOfEverythingRainfallYData = new InternetOfEverythingChartYDataVo();
                if ("\u6700\u9ad8\u6e7f\u5ea6".equals(humidnessType)) {
                    internetOfEverythingRainfallYData.setName("\u6700\u9ad8\u6e7f\u5ea6");
                    internetOfEverythingRainfallYData.setYData(maxDatas);
                }
                if ("\u6700\u4f4e\u6e7f\u5ea6".equals(humidnessType)) {
                    internetOfEverythingRainfallYData.setName("\u6700\u4f4e\u6e7f\u5ea6");
                    internetOfEverythingRainfallYData.setYData(minDatas);
                }
                if ("\u5e73\u5747\u6e7f\u5ea6".equals(humidnessType)) {
                    internetOfEverythingRainfallYData.setName("\u5e73\u5747\u6e7f\u5ea6");
                    internetOfEverythingRainfallYData.setYData(avgDatas);
                }
                internetOfEverythingRainfallYDataList.add(internetOfEverythingRainfallYData);
            }
            internetOfEverythingChartVo.setLegendData(humidnessTypes);
        }
        internetOfEverythingChartVo.setXData(dateList);
        internetOfEverythingChartVo.setYDatas(internetOfEverythingRainfallYDataList);
    }

    private void setPolylineChartByTime(InternetOfEverythingChartVo internetOfEverythingChartVo, List<InternetOfEverythingChartYDataVo> internetOfEverythingRainfallYDataList, Timestamp startTimestamp, Timestamp endTimestamp, Integer humitureType, Integer companyId) {
        List<String> temperatureTypes = Arrays.asList("\u5f53\u524d\u65f6\u523b\u6e29\u5ea6");
        List<String> humidnessTypes = Arrays.asList("\u5f53\u524d\u65f6\u523b\u6e7f\u5ea6");
        String timePattern = "HH:mm";
        List internetOfEverythingAtmosphereList = this.internetOfEverythingDpMapper.queryAtmosphereByTime(startTimestamp, endTimestamp, humitureType, companyId);
        List timeList = internetOfEverythingAtmosphereList.stream().map(t -> DateUtils.dateToString((Date)t.getDateTime(), (String)timePattern)).collect(Collectors.toList());
        List defaultDatas = internetOfEverythingAtmosphereList.stream().map(t -> t.getDefaultData()).collect(Collectors.toList());
        InternetOfEverythingChartYDataVo internetOfEverythingRainfallYData = new InternetOfEverythingChartYDataVo();
        if (1 == humitureType) {
            internetOfEverythingRainfallYData.setName("\u5f53\u524d\u65f6\u523b\u6e29\u5ea6");
            internetOfEverythingChartVo.setLegendData(temperatureTypes);
        }
        if (2 == humitureType) {
            internetOfEverythingRainfallYData.setName("\u5f53\u524d\u65f6\u523b\u6e7f\u5ea6");
            internetOfEverythingChartVo.setLegendData(humidnessTypes);
        }
        internetOfEverythingRainfallYData.setYData(defaultDatas);
        internetOfEverythingRainfallYDataList.add(internetOfEverythingRainfallYData);
        internetOfEverythingChartVo.setXData(timeList);
        internetOfEverythingChartVo.setYDatas(internetOfEverythingRainfallYDataList);
    }

    public InternetOfEverythingChartVo queryCropEvapotranspiration(Integer companyId) {
        InternetOfEverythingChartVo internetOfEverythingChartVo = new InternetOfEverythingChartVo();
        ArrayList<InternetOfEverythingChartYDataVo> yDatas = new ArrayList<InternetOfEverythingChartYDataVo>();
        InternetOfEverythingChartYDataVo yData = new InternetOfEverythingChartYDataVo();
        InternetOfEverythingCropEvapotranspirationDto internetOfEverythingCropEvapotranspirationDto = this.internetOfEverythingDpMapper.queryCropEvapotranspiration(companyId);
        if (ObjectUtil.isNull((Object)internetOfEverythingCropEvapotranspirationDto)) {
            return internetOfEverythingChartVo;
        }
        String[] ets = internetOfEverythingCropEvapotranspirationDto.getEt().replace("{", "").replace("}", "").split(",");
        Date startDate = internetOfEverythingCropEvapotranspirationDto.getStartDate();
        Date endDate = DateUtils.dateAddDays((Date)startDate, (int)170);
        List dates = DateUtils.getAllDays((Date)startDate, (Date)endDate);
        List dateToStrings = dates.stream().map(t -> DateUtils.dateToString((Date)t, (String)"MM/dd")).collect(Collectors.toList());
        yData.setYData(Arrays.asList(ets));
        yDatas.add(yData);
        internetOfEverythingChartVo.setXData(dateToStrings);
        internetOfEverythingChartVo.setYDatas(yDatas);
        return internetOfEverythingChartVo;
    }

    public InternetOfEverythingChartVo queryCropDemand(Integer demandType, Integer companyId) {
        InternetOfEverythingChartVo internetOfEverythingChartVo = new InternetOfEverythingChartVo();
        InternetOfEverythingCropDemandDto internetOfEverythingCropDemandDto = this.internetOfEverythingDpMapper.queryCropDemand(companyId);
        if (ObjectUtil.isNull((Object)internetOfEverythingCropDemandDto)) {
            return internetOfEverythingChartVo;
        }
        String[] nReqs = internetOfEverythingCropDemandDto.getNReq().replace("{", "").replace("}", "").split(",");
        String[] pReqs = internetOfEverythingCropDemandDto.getPReq().replace("{", "").replace("}", "").split(",");
        String[] kReqs = internetOfEverythingCropDemandDto.getKReq().replace("{", "").replace("}", "").split(",");
        String[] waterReqs = internetOfEverythingCropDemandDto.getWaterReq().replace("{", "").replace("}", "").split(",");
        String[] growthStages = internetOfEverythingCropDemandDto.getGrowthStage().replace("{", "").replace("}", "").replaceAll("\"", "").split(",");
        String[] growthStageDates = internetOfEverythingCropDemandDto.getGrowthStageDate().replace("{", "").replace("}", "").split(",");
        ArrayList<InternetOfEverythingChartYDataVo> yDatas = new ArrayList<InternetOfEverythingChartYDataVo>();
        ArrayList<String> xDatas = new ArrayList<String>();
        for (int i = 0; i < growthStages.length; ++i) {
            String xData = growthStages[i] + "\n" + growthStageDates[i].substring(5).replace("-", "/");
            xDatas.add(xData);
        }
        if (demandType == 1) {
            List<String> legendDatas = Arrays.asList("\u6c2e", "\u78f7", "\u94be");
            for (String s : legendDatas) {
                InternetOfEverythingChartYDataVo internetOfEverythingChartYDataVo = new InternetOfEverythingChartYDataVo();
                internetOfEverythingChartYDataVo.setName(s);
                if ("\u6c2e".equals(s)) {
                    internetOfEverythingChartYDataVo.setYData(Arrays.asList(nReqs));
                }
                if ("\u78f7".equals(s)) {
                    internetOfEverythingChartYDataVo.setYData(Arrays.asList(pReqs));
                }
                if ("\u94be".equals(s)) {
                    internetOfEverythingChartYDataVo.setYData(Arrays.asList(kReqs));
                }
                yDatas.add(internetOfEverythingChartYDataVo);
            }
            internetOfEverythingChartVo.setLegendData(legendDatas);
        }
        if (demandType == 2) {
            InternetOfEverythingChartYDataVo internetOfEverythingChartYDataVo = new InternetOfEverythingChartYDataVo();
            internetOfEverythingChartYDataVo.setYData(Arrays.asList(waterReqs));
            yDatas.add(internetOfEverythingChartYDataVo);
        }
        internetOfEverythingChartVo.setXData(xDatas);
        internetOfEverythingChartVo.setYDatas(yDatas);
        return internetOfEverythingChartVo;
    }

    public List<InternetOfEverythingMapVo> queryInternetOfEverythingMap(Integer tabType, Integer companyId) {
        ArrayList<InternetOfEverythingMapVo> internetOfEverythingMapVos = new ArrayList<InternetOfEverythingMapVo>();
        List internetOfEverythingMapFacilityPgs = this.internetOfEverythingDpMapper.queryEnvironmentalMonitoringFacilityPg(companyId);
        if (tabType == 1) {
            List meteorologicalStations = internetOfEverythingMapFacilityPgs.stream().filter(t -> t.getDeviceType() == 1).collect(Collectors.toList());
            List soilMoistureContents = internetOfEverythingMapFacilityPgs.stream().filter(t -> t.getDeviceType() == 2).collect(Collectors.toList());
            List unmannedAerialVehicles = internetOfEverythingMapFacilityPgs.stream().filter(t -> t.getDeviceType() == 6).collect(Collectors.toList());
            List waterFertilizerMachines = internetOfEverythingMapFacilityPgs.stream().filter(t -> t.getDeviceType() == 7).collect(Collectors.toList());
            List waterLevels = internetOfEverythingMapFacilityPgs.stream().filter(t -> t.getDeviceType() == 8).collect(Collectors.toList());
            this.addFacility(internetOfEverythingMapVos, meteorologicalStations, Integer.valueOf(1), "\u667a\u80fd\u6c14\u8c61\u7ad9");
            this.addFacility(internetOfEverythingMapVos, soilMoistureContents, Integer.valueOf(2), "\u571f\u58e4\u5892\u60c5\u4eea");
            this.addFacility(internetOfEverythingMapVos, unmannedAerialVehicles, Integer.valueOf(6), "\u65e0\u4eba\u673a\u573a");
            this.addFacility(internetOfEverythingMapVos, waterFertilizerMachines, Integer.valueOf(7), "\u6c34\u80a5\u4e00\u4f53\u673a");
            this.addFacility(internetOfEverythingMapVos, waterLevels, Integer.valueOf(8), "\u6c34\u4f4d\u4eea");
        }
        return internetOfEverythingMapVos;
    }

    private void addFacility(List<InternetOfEverythingMapVo> internetOfEverythingMapVos, List<InternetOfEverythingMapFacilityVo> internetOfEverythingMapFacilityVos, Integer type, String facility) {
        InternetOfEverythingMapVo internetOfEverything = new InternetOfEverythingMapVo();
        internetOfEverything.setFacility(facility);
        internetOfEverything.setQuantity(Integer.valueOf(internetOfEverythingMapFacilityVos.size()));
        internetOfEverything.setType(type);
        internetOfEverything.setInternetOfEverythingMapFacilitys(internetOfEverythingMapFacilityVos);
        internetOfEverythingMapVos.add(internetOfEverything);
    }

    public InternetOfEverythingMapFacilityVo queryDeviceMessage(String deviceNameId, Integer deviceType, Integer companyId) {
        InternetOfEverythingMapFacilityVo internetOfEverythingMapFacilityVo = new InternetOfEverythingMapFacilityVo();
        if (deviceType == 1 || deviceType == 2 || deviceType == 6 || deviceType == 7 || deviceType == 8) {
            internetOfEverythingMapFacilityVo = this.internetOfEverythingDpMapper.queryFacilityPgById(deviceNameId, companyId);
        }
        return internetOfEverythingMapFacilityVo;
    }

    public PageListVO<DeviceVo> queryDeviceVoList(Integer currentPage, Integer pageSize, Integer companyId) {
        try {
            if (currentPage == null) {
                currentPage = 1;
            }
            if (pageSize == null) {
                pageSize = 20;
            }
            Integer pageIndex = (currentPage - 1) * pageSize;
            PageListVO pageListVO = new PageListVO();
            PaginationVO pagination = new PaginationVO();
            List list = this.internetOfEverythingDpMapper.queryDeviceVoList(pageIndex, pageSize, companyId);
            List totalList = this.internetOfEverythingDpMapper.queryDeviceVoListAll(companyId);
            pagination.setCurrentPage(Long.valueOf(currentPage.longValue()));
            pagination.setPageSize(Long.valueOf(pageSize.longValue()));
            pagination.setTotal(Integer.valueOf(totalList.size()));
            pageListVO.setList(list);
            pageListVO.setPagination(pagination);
            return pageListVO;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u4e07\u7269\u4e92\u8054-\u83b7\u53d6\u571f\u58e4\u5892\u60c5\u4eea\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
            throw new DataException("\u4e07\u7269\u4e92\u8054-\u83b7\u53d6\u571f\u58e4\u5892\u60c5\u4eea\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public PestCountVo queryPestCount(String startTime, String endTime, Integer companyId) {
        try {
            PestCountVo countVo = new PestCountVo();
            List<Object> legendData = Lists.newArrayList();
            List pestCountList = this.internetOfEverythingDpMapper.queryPestDetectionImgId(startTime, endTime, companyId);
            ArrayList sortPestCountList = Lists.newArrayList();
            ArrayList sortPestNameList = Lists.newArrayList();
            List<Object> sortList = Lists.newArrayList();
            ArrayList pestNameList = Lists.newArrayList();
            pestNameList.add("\u8349\u5730\u8d2a\u591c\u86fe");
            pestNameList.add("\u9ecf\u866b");
            pestNameList.add("\u84df\u9a6c");
            pestNameList.add("\u7389\u7c73\u869c");
            pestNameList.add("\u751c\u83dc\u591c\u86fe");
            pestNameList.add("\u7389\u7c73\u53f6\u87a8");
            pestNameList.add("\u4e8c\u70b9\u59d4\u591c\u86fe");
            pestNameList.add("\u7070\u98de\u8671");
            pestNameList.add("\u7389\u7c73\u879f");
            pestNameList.add("\u8757\u866b");
            if (StringUtil.isNotEmpty((Collection)pestCountList)) {
                for (PestDataChartVo chartVo : pestCountList) {
                    if (pestNameList.contains(chartVo.getName())) {
                        sortPestNameList.add(chartVo);
                        continue;
                    }
                    sortPestCountList.add(chartVo);
                }
                sortList = Stream.concat(sortPestNameList.stream(), sortPestCountList.stream()).collect(Collectors.toList());
                legendData = sortList.stream().map(PestDataChartVo::getName).collect(Collectors.toList());
                countVo.setLegendData((List)legendData);
                countVo.setDataList(sortList);
            }
            return countVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u75c5\u866b\u5bb3\u76d1\u6d4b\u5206\u6790-\u75c5\u866b\u7edf\u8ba1\u67e5\u8be2\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u75c5\u866b\u5bb3\u76d1\u6d4b\u5206\u6790-\u75c5\u866b\u7edf\u8ba1\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public List<DiseaseInsectWarningVo> queryDiseaseInsectWarning() {
        try {
            List vo = this.internetOfEverythingDpMapper.queryDiseaseInsectWarning();
            return vo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u75c5\u866b\u60c5\u62a5\u9884\u8b66\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u75c5\u866b\u60c5\u62a5\u9884\u8b66\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public List<PestDetectionImgVo> queryPestDetectionImgInfo() {
        try {
            List listVo = this.internetOfEverythingDpMapper.queryPestDetectionImgInfo();
            return listVo;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u75c5\u866b\u5bb3\u76d1\u6d4b\u5206\u6790-\u5b9e\u62cd\u56fe\u7247\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u75c5\u866b\u5bb3\u76d1\u6d4b\u5206\u6790-\u5b9e\u62cd\u56fe\u7247\u63a5\u53e3\u67e5\u8be2\u5931\u8d25\uff01");
        }
    }

    public List<InternetOfEverythingCropMonitoringVo> queryCropMonitoring(String startTime, String endTime, String deviceNameId) {
        startTime = startTime + " 00:00:00";
        endTime = endTime + " 23:59:59";
        List internetOfEverythingCropMonitorings = this.internetOfEverythingDpMapper.queryCropMonitoring(startTime, endTime, deviceNameId);
        return internetOfEverythingCropMonitorings;
    }

    public ChartVo trendAnalysis(String startTime, String endTime, Integer companyId) {
        List pestCountChartVos = this.internetOfEverythingDpMapper.queryPestCount(startTime, endTime, companyId);
        ChartVo chartVo = new ChartVo();
        List xData = pestCountChartVos.stream().map(PestCountChartVo::getCreateTime).distinct().collect(Collectors.toList());
        List ehmData = pestCountChartVos.stream().filter(pestCountChartVo -> "\u4e8c\u5316\u879f".equals(pestCountChartVo.getPestName())).map(PestCountChartVo::getPestCount).collect(Collectors.toList());
        List dzjymData = pestCountChartVos.stream().filter(pestCountChartVo -> "\u7a3b\u7eb5\u5377\u53f6\u879f".equals(pestCountChartVo.getPestName())).map(PestCountChartVo::getPestCount).collect(Collectors.toList());
        chartVo.setXData(xData);
        chartVo.setEhmData(ehmData);
        chartVo.setDzjymData(dzjymData);
        return chartVo;
    }

    public ChartVo pestChart(String startTime, String endTime, Integer companyId, String deviceId) {
        List pestCountChartVos = this.internetOfEverythingDpMapper.pestChart(startTime, endTime, companyId, deviceId);
        ChartVo chartVo = new ChartVo();
        List xData = pestCountChartVos.stream().map(PestCountChartVo::getCreateTime).collect(Collectors.toList());
        List yData = pestCountChartVos.stream().map(PestCountChartVo::getPestCount).collect(Collectors.toList());
        chartVo.setXData(xData);
        chartVo.setYData(yData);
        return chartVo;
    }

    public InternetOfEverythingDpServiceImpl(InternetOfEverythingDpMapper internetOfEverythingDpMapper) {
        this.internetOfEverythingDpMapper = internetOfEverythingDpMapper;
    }
}

