/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.shuxi.bean.ca.IrrigationCase;
import com.shuxi.bean.dto.PondDTO;
import com.shuxi.bean.entity.FlowmeterLogEntity;
import com.shuxi.bean.vo.DosageDateVo;
import com.shuxi.bean.vo.EquipmentVo;
import com.shuxi.bean.vo.FieldVo;
import com.shuxi.bean.vo.ImageDataVo;
import com.shuxi.bean.vo.IrrigateFormulaVo;
import com.shuxi.bean.vo.IrrigationSystemDataVo;
import com.shuxi.bean.vo.IrrigationVo;
import com.shuxi.bean.vo.IrrigationWarnVo;
import com.shuxi.bean.vo.PondVO;
import com.shuxi.bean.vo.UnitVo;
import com.shuxi.bean.vo.WaterValveVO;
import com.shuxi.mapper.FlowmeterLogMapper;
import com.shuxi.mapper.IrrigationMapper;
import com.shuxi.service.IrrigationService;
import com.shuxi.service.MqttClientService;
import com.shuxi.util.BigDecimalUtils;
import com.shuxi.util.DateUtils;
import com.shuxi.util.ParamAESUtil;
import com.shuxi.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class IrrigationServiceImpl
implements IrrigationService {
    private final IrrigationMapper irrigationMapper;
    private final MqttClientService mqttClientService;
    private final FlowmeterLogMapper flowmeterLogMapper;
    private static final Double val = 5.0;

    public List<IrrigationVo> planList(IrrigationCase irrigationCase) {
        Long pageNum = irrigationCase.getCurrentPage();
        Long pageSize = irrigationCase.getPageSize();
        if (pageNum != null && pageNum != null) {
            irrigationCase.setStart(Long.valueOf((pageNum - 1L) * pageSize));
        }
        List list = this.irrigationMapper.planList(irrigationCase);
        Integer count = this.irrigationMapper.planListCount(irrigationCase);
        if (list.size() > 0) {
            List unList = this.irrigationMapper.queryUnitList(list);
            list.forEach(item -> {
                if (StringUtil.isNotBlank((CharSequence)item.getIrrigateText()) && item.getIrrigateText().indexOf("\u5168\u5c40\u704c\u6e89") > -1) {
                    item.setUnitText(item.getIrrigateText());
                } else {
                    List nameList = unList.stream().filter(it -> it.getPlanId().equals(item.getPlanId())).map(it -> it.getName()).collect(Collectors.toList());
                    item.setUnitText(StringUtil.join(nameList, (String)" , "));
                }
            });
        }
        return irrigationCase.setData(list, (long)count.intValue());
    }

    public List<IrrigateFormulaVo> irrigateFormulaList(String periodName, Integer companyId) {
        return this.irrigationMapper.irrigateFormulaList(periodName, companyId);
    }

    public List<UnitVo> unitVoListByPlanId(String planId, String id, Integer companyId) {
        List list = this.irrigationMapper.unitVoListByPlanId(planId, id, companyId);
        if (list.size() > 0) {
            String nowTime = DateUtil.date().toString();
            List listStat = this.irrigationMapper.unitVoListByPlanIdStat(planId, id, val, companyId);
            list.forEach(item -> {
                listStat.forEach(it -> {
                    if (item.getId().equals(it.getId())) {
                        item.setDosage(it.getDosage());
                        item.setStatus(it.getStatus());
                        item.setStartTime(it.getStartTime());
                        item.setEndTime(it.getEndTime());
                    }
                });
                item.setNowTime(nowTime);
            });
        }
        return list;
    }

    public IrrigationSystemDataVo unitVoStatByPlanId(String planId, String id, Integer companyId) {
        IrrigationSystemDataVo irrigationSystemDataVo = new IrrigationSystemDataVo();
        this.setGgData(irrigationSystemDataVo, planId, id, companyId);
        this.setPsData(irrigationSystemDataVo, id, companyId);
        return irrigationSystemDataVo;
    }

    private void setPsData(IrrigationSystemDataVo irrigationSystemDataVo, String id, Integer companyId) {
        EquipmentVo planInfo = this.irrigationMapper.psPlanIdLimit(id);
        String planId = planInfo.getPlanId();
        List list = this.irrigationMapper.unitVoStatByPlanId(planId, id, val, companyId);
        String execTime = this.irrigationMapper.getExectimeById(planId, companyId);
        Date execTimeDate = DateUtils.stringToDates((String)execTime);
        if (list.size() > 0) {
            List nameList = this.irrigationMapper.unitList(list);
            list.forEach(item -> nameList.forEach(it -> {
                if (item.getId().equals(it.getId())) {
                    item.setArea(it.getArea());
                    item.setName(it.getName());
                }
            }));
        }
        AtomicReference<BigDecimal> areaSum = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> areaFinish = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<Integer> ggCount = new AtomicReference<Integer>(0);
        Integer countAll = list.size();
        AtomicReference<BigDecimal> operationTime = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> sumTime = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> sumVal = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        list.forEach(item -> {
            BigDecimal itemArea = new BigDecimal(item.getArea());
            BigDecimal itemTime = new BigDecimal(item.getValTime());
            BigDecimal itemAllTime = new BigDecimal(item.getSumValTime());
            BigDecimal itemSumVal = new BigDecimal(item.getSumVal());
            if (itemTime.doubleValue() >= itemAllTime.doubleValue()) {
                ggCount.getAndSet((Integer)ggCount.get() + 1);
                areaFinish.set(((BigDecimal)areaFinish.get()).add(itemArea));
            }
            operationTime.set(((BigDecimal)operationTime.get()).add(itemTime));
            sumTime.set(((BigDecimal)sumTime.get()).add(itemAllTime));
            sumVal.set(((BigDecimal)sumVal.get()).add(itemSumVal));
            areaSum.set(((BigDecimal)areaSum.get()).add(itemArea));
        });
        irrigationSystemDataVo.setPsExecTime(execTimeDate);
        String psOperationTime = operationTime.get().toString();
        irrigationSystemDataVo.setPsOperationTime(DateUtils.secondsToHourMinuteSecond((String)psOperationTime));
        String psSumTime = sumTime.get().toString();
        irrigationSystemDataVo.setPsSumTime(DateUtils.secondsToHourMinuteSecond((String)psSumTime));
        String psSurplustTime = BigDecimalUtils.sub((String)psSumTime, (String)psOperationTime).toString();
        irrigationSystemDataVo.setPsSurplustTime(DateUtils.secondsToHourMinuteSecond((String)psSurplustTime));
        String psTimeProgress = "0";
        if (BigDecimal.ZERO.compareTo(new BigDecimal(psSumTime)) != 0) {
            psTimeProgress = BigDecimalUtils.mul((String)BigDecimalUtils.div((String)psOperationTime, (String)psSumTime, (int)4), (String)new String("100"), (int)1).toString();
        }
        irrigationSystemDataVo.setPsTimeProgress(psTimeProgress);
        String psAreaSum = areaSum.get().toString();
        irrigationSystemDataVo.setPsAreaSum(psAreaSum);
        String psAreaFinish = areaFinish.get().toString();
        irrigationSystemDataVo.setPsAreaFinish(psAreaFinish);
        String psAreaSurplust = BigDecimalUtils.sub((String)psAreaSum, (String)psAreaFinish).toString();
        irrigationSystemDataVo.setPsAreaSurplust(psAreaSurplust);
        String psAreaProgress = "0";
        if (BigDecimal.ZERO.compareTo(new BigDecimal(psAreaSum)) != 0) {
            psAreaProgress = BigDecimalUtils.mul((String)BigDecimalUtils.div((String)psAreaFinish, (String)psAreaSum, (int)4), (String)new String("100"), (int)1).toString();
        }
        irrigationSystemDataVo.setPsAreaProgress(psAreaProgress);
        Integer psCountAll = countAll;
        irrigationSystemDataVo.setPsCountAll(psCountAll);
        Integer psFinishCount = (int)ggCount.get();
        irrigationSystemDataVo.setPsFinishCount(psFinishCount);
        Integer psSurplustCount = psCountAll - psFinishCount;
        irrigationSystemDataVo.setPsSurplustCount(psSurplustCount);
    }

    private void setGgData(IrrigationSystemDataVo irrigationSystemDataVo, String planId, String id, Integer companyId) {
        List list = this.irrigationMapper.unitVoStatByPlanId(planId, id, val, companyId);
        String execTime = this.irrigationMapper.getExectimeById(planId, companyId);
        Date execTimeDate = DateUtils.stringToDates((String)execTime);
        if (list.size() > 0) {
            List nameList = this.irrigationMapper.unitList(list);
            list.forEach(item -> nameList.forEach(it -> {
                if (item.getId().equals(it.getId())) {
                    item.setArea(it.getArea());
                    item.setName(it.getName());
                }
            }));
        }
        AtomicReference<BigDecimal> areaSum = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> areaFinish = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<Integer> ggCount = new AtomicReference<Integer>(0);
        Integer countAll = list.size();
        AtomicReference<BigDecimal> operationTime = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> sumTime = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        AtomicReference<BigDecimal> sumVal = new AtomicReference<BigDecimal>(new BigDecimal("0.00"));
        list.forEach(item -> {
            BigDecimal itemArea = new BigDecimal(item.getArea());
            BigDecimal itemTime = new BigDecimal(item.getValTime());
            BigDecimal itemAllTime = new BigDecimal(item.getSumValTime());
            BigDecimal itemSumVal = new BigDecimal(item.getSumVal());
            if (itemTime.doubleValue() >= itemAllTime.doubleValue()) {
                ggCount.getAndSet((Integer)ggCount.get() + 1);
                areaFinish.set(((BigDecimal)areaFinish.get()).add(itemArea));
            }
            operationTime.set(((BigDecimal)operationTime.get()).add(itemTime));
            sumTime.set(((BigDecimal)sumTime.get()).add(itemAllTime));
            sumVal.set(((BigDecimal)sumVal.get()).add(itemSumVal));
            areaSum.set(((BigDecimal)areaSum.get()).add(itemArea));
        });
        irrigationSystemDataVo.setSumVal(sumVal.get().toString());
        irrigationSystemDataVo.setGgExecTime(execTimeDate);
        String ggOperationTime = operationTime.get().toString();
        irrigationSystemDataVo.setGgOperationTime(DateUtils.secondsToHourMinuteSecond((String)ggOperationTime));
        String ggSumTime = sumTime.get().toString();
        irrigationSystemDataVo.setGgSumTime(DateUtils.secondsToHourMinuteSecond((String)ggSumTime));
        String ggSurplustTime = BigDecimalUtils.sub((String)ggSumTime, (String)ggOperationTime).toString();
        irrigationSystemDataVo.setGgSurplustTime(DateUtils.secondsToHourMinuteSecond((String)ggSurplustTime));
        String ggTimeProgress = "0";
        if (BigDecimal.ZERO.compareTo(new BigDecimal(ggSumTime)) != 0) {
            ggTimeProgress = BigDecimalUtils.mul((String)BigDecimalUtils.div((String)ggOperationTime, (String)ggSumTime, (int)4), (String)new String("100"), (int)1).toString();
        }
        irrigationSystemDataVo.setGgTimeProgress(ggTimeProgress);
        String ggAreaSum = areaSum.get().toString();
        irrigationSystemDataVo.setGgAreaSum(ggAreaSum);
        String ggAreaFinish = areaFinish.get().toString();
        irrigationSystemDataVo.setGgAreaFinish(ggAreaFinish);
        String ggAreaSurplust = BigDecimalUtils.sub((String)ggAreaSum, (String)ggAreaFinish).toString();
        irrigationSystemDataVo.setGgAreaSurplust(ggAreaSurplust);
        String ggAreaProgress = "0";
        if (BigDecimal.ZERO.compareTo(new BigDecimal(ggAreaSum)) != 0) {
            ggAreaProgress = BigDecimalUtils.mul((String)BigDecimalUtils.div((String)ggAreaFinish, (String)ggAreaSum, (int)4), (String)new String("100"), (int)1).toString();
        }
        irrigationSystemDataVo.setGgAreaProgress(ggAreaProgress);
        Integer ggCountAll = countAll;
        irrigationSystemDataVo.setGgCountAll(ggCountAll);
        Integer ggFinishCount = (int)ggCount.get();
        irrigationSystemDataVo.setGgFinishCount(ggFinishCount);
        Integer ggSurplustCount = ggCountAll - ggFinishCount;
        irrigationSystemDataVo.setGgSurplustCount(ggSurplustCount);
    }

    public List<EquipmentVo> underwayPlanId(Integer companyId) {
        List equipmentVos = this.irrigationMapper.equipmentList(companyId);
        if (equipmentVos.size() > 0) {
            List list = this.irrigationMapper.underwayIdToNow(val, companyId);
            List yearList = this.irrigationMapper.underwayIdToYear(val, companyId);
            List statList = this.irrigationMapper.queryMainStatus(companyId);
            equipmentVos.forEach(item -> {
                EquipmentVo planInfo;
                List collect = list.stream().filter(it -> it.getBindId().equals(item.getId())).collect(Collectors.toList());
                item.setDayDosage(this.dayDosage(collect));
                yearList.forEach(it -> {
                    if (it.getId().equals(item.getId())) {
                        item.setYearDosage(it.getYearDosage());
                    }
                });
                statList.forEach(it -> {
                    if (it.getId().equals(item.getId())) {
                        item.setStatus(Integer.valueOf(it.getStatus() > 0 ? 1 : 0));
                    }
                });
                if (StringUtil.isBlank((CharSequence)item.getDayDosage())) {
                    item.setDayDosage("0.00");
                }
                if (StringUtil.isBlank((CharSequence)item.getYearDosage())) {
                    item.setYearDosage("0.00");
                }
                if (item.getStatus() == null) {
                    item.setStatus(Integer.valueOf(0));
                }
                if ((planInfo = this.irrigationMapper.planIdLimit(item.getId(), companyId)) != null) {
                    Integer sumDosage = this.irrigationMapper.sumDosage(companyId);
                    item.setSumDosage(String.valueOf(sumDosage));
                    item.setPlanId(planInfo.getPlanId());
                    item.setPlanStart(planInfo.getPlanStart());
                    item.setPlanEnd(planInfo.getPlanEnd());
                }
            });
        }
        return equipmentVos;
    }

    private String dayDosage(List<EquipmentVo> list) {
        DateTime startDate = null;
        DateTime endDate = null;
        Long sumMs = 0L;
        for (EquipmentVo item : list) {
            if (startDate == null) {
                startDate = DateUtil.parse((CharSequence)item.getStartTime());
                endDate = DateUtil.parse((CharSequence)item.getEndTime());
                continue;
            }
            DateTime nowStart = DateUtil.parse((CharSequence)item.getStartTime());
            DateTime nowEnd = DateUtil.parse((CharSequence)item.getEndTime());
            if (endDate.getTime() >= nowStart.getTime() && nowStart.getTime() >= startDate.getTime()) {
                if (endDate.getTime() >= nowEnd.getTime()) continue;
                endDate = nowEnd;
                continue;
            }
            sumMs = sumMs + DateUtil.between((Date)startDate, (Date)endDate, (DateUnit)DateUnit.SECOND);
            System.out.println("sumMs=======================" + sumMs);
            endDate = nowEnd;
            startDate = nowStart;
        }
        if (list.size() > 0 && startDate != null && endDate != null) {
            sumMs = sumMs + DateUtil.between((Date)startDate, endDate, (DateUnit)DateUnit.SECOND);
        }
        BigDecimal sum = new BigDecimal(sumMs);
        BigDecimal value = sum.divide(new BigDecimal(60), 2, RoundingMode.DOWN).multiply(new BigDecimal(val));
        String result = value.stripTrailingZeros().toString();
        return result;
    }

    public JSONObject dosageStatVo(String ids, String rangTime, Integer companyId) {
        String startTime = null;
        String endTime = null;
        if (StringUtil.isNotBlank((CharSequence)rangTime)) {
            String[] split = rangTime.split(",");
            startTime = split[0];
            endTime = split[1];
        }
        List<String> idList = Arrays.asList(ids.split(","));
        JSONObject json = new JSONObject();
        if (idList.size() == 0) {
            return json;
        }
        List dosageDateVos = this.irrigationMapper.dosageStatVo(idList, startTime, endTime, val, companyId);
        List nameList = this.irrigationMapper.mainNameList(idList, companyId);
        DateTime start = DateUtil.parse((CharSequence)startTime);
        DateTime end = DateUtil.parse((CharSequence)endTime);
        long between = DateUtil.between((Date)start, (Date)end, (DateUnit)DateUnit.DAY);
        idList.forEach(item -> {
            List name = nameList.stream().filter(it -> item.equals(it.getBindId())).collect(Collectors.toList());
            if (name.size() > 0) {
                List<DosageDateVo> collect = dosageDateVos.stream().filter(it -> it.getBindId().equals(item)).collect(Collectors.toList());
                collect.forEach(it -> it.setBindName(((DosageDateVo)name.get(0)).getBindName()));
                List date = this.createDate(start, Long.valueOf(between), item, ((DosageDateVo)name.get(0)).getBindName());
                String key = "sb_1";
                if (collect.size() == 0) {
                    json.put(key, (Object)date);
                } else {
                    List dateList = collect.stream().map(it -> it.getStartTime()).collect(Collectors.toList());
                    List collect2 = date.stream().filter(it -> !dateList.contains(it.getStartTime())).collect(Collectors.toList());
                    collect.addAll(collect2);
                    json.put(key, collect.stream().sorted(Comparator.comparing(DosageDateVo::getStartTime)).collect(Collectors.toList()));
                }
            }
        });
        return json;
    }

    private List<DosageDateVo> createDate(DateTime start, Long between, String id, String name) {
        ArrayList<DosageDateVo> newList = new ArrayList<DosageDateVo>();
        int i = 0;
        while ((long)i < between) {
            DosageDateVo dosageDateVo = new DosageDateVo();
            DateTime nowDate = DateUtil.offsetDay((Date)start, (int)i);
            String dateStr = nowDate.toDateStr();
            dosageDateVo.setStartTime(dateStr);
            dosageDateVo.setVal("0.00");
            dosageDateVo.setBindId(id);
            dosageDateVo.setBindName(name);
            newList.add(dosageDateVo);
            ++i;
        }
        return newList;
    }

    public List<String> queryDateByType(Integer type, Integer companyId) {
        return this.irrigationMapper.queryDateByType(type, companyId);
    }

    public List<ImageDataVo> imgListByTypeAndDate(Integer type, String date, Integer companyId) {
        return this.irrigationMapper.imgListByTypeAndDate(type, date, companyId);
    }

    public List<IrrigationWarnVo> irrigationMonitoring(Long id) {
        return this.irrigationMapper.irrigationMonitoring(id);
    }

    public EquipmentVo mainEquipment(String id) {
        EquipmentVo equipmentVo = this.irrigationMapper.mainEquipment(id);
        if (equipmentVo != null) {
            List list = this.irrigationMapper.mainEquipmentList(id);
            equipmentVo.setList(list);
            equipmentVo.setUnitCount(this.irrigationMapper.unitCount(id));
        }
        return equipmentVo;
    }

    public Integer addPlan(String id, Integer status) {
        return this.irrigationMapper.addPlan(id, status);
    }

    public FieldVo selectById(String fieldId) {
        String id = ParamAESUtil.dealStr((String)fieldId, (int)2);
        FieldVo fieldVo = this.irrigationMapper.selectById(id);
        return fieldVo;
    }

    public PondVO pondList(Integer companyId) {
        List list = this.irrigationMapper.selectPondByCompanyId(companyId);
        ArrayList<PondDTO> pumpList = new ArrayList<PondDTO>();
        ArrayList<PondDTO> pondList = new ArrayList<PondDTO>();
        for (PondDTO pondDTO : list) {
            String[] data = new String[]{pondDTO.getLng(), pondDTO.getLat()};
            pondDTO.setData(data);
            if (1 == pondDTO.getType()) {
                pumpList.add(pondDTO);
            }
            if (2 != pondDTO.getType()) continue;
            pondList.add(pondDTO);
        }
        PondVO pondVO = new PondVO();
        pondVO.setPumpList(pumpList);
        pondVO.setPondList(pondList);
        return pondVO;
    }

    public List<WaterValveVO> getWaterValves(Integer companyId, String bindId) {
        List list = this.irrigationMapper.getWaterValves(companyId, bindId);
        return list;
    }

    public List<UnitVo> fieldAndWaterValveList(String id, Integer companyId) {
        List list = this.irrigationMapper.fieldList(companyId);
        List waterValveList = this.irrigationMapper.waterValveList(id, companyId);
        List waterLevelList = this.irrigationMapper.waterLevelList(id, companyId);
        for (UnitVo unitVo : list) {
            List waterLevels;
            List waterValves = waterValveList.stream().filter(wv -> unitVo.getId().equals(wv.getId())).collect(Collectors.toList());
            if (CollUtil.isNotEmpty(waterValves)) {
                unitVo.setList(((UnitVo)waterValves.get(0)).getList());
            }
            if (!CollUtil.isNotEmpty(waterLevels = waterLevelList.stream().filter(wl -> unitVo.getId().equals(wl.getFieldId())).collect(Collectors.toList()))) continue;
            unitVo.setWaterLevelList(waterLevels);
        }
        return list;
    }

    public List<WaterValveVO> getWaterValveList(Integer companyId) {
        List list = this.irrigationMapper.getWaterValveList(companyId);
        return list;
    }

    public List<WaterValveVO> getWaterDevices(Integer companyId, String deviceCode) {
        List list = this.irrigationMapper.getWaterDevices(companyId, deviceCode);
        return list;
    }

    public String getFlowmeterValue(String code) {
        this.mqttClientService.mqttSendFlowmeter(code, Integer.valueOf(2));
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowmeterLogEntity::getCtlCode, (Object)code)).orderByDesc(FlowmeterLogEntity::getCreateTime);
        List flowmeterLogEntities = this.flowmeterLogMapper.selectList((Wrapper)queryWrapper);
        String flowmeterValue = "0";
        if (CollUtil.isNotEmpty((Collection)flowmeterLogEntities)) {
            flowmeterValue = ((FlowmeterLogEntity)flowmeterLogEntities.get(0)).getCtlVolume();
        }
        return flowmeterValue;
    }

    public IrrigationServiceImpl(IrrigationMapper irrigationMapper, MqttClientService mqttClientService, FlowmeterLogMapper flowmeterLogMapper) {
        this.irrigationMapper = irrigationMapper;
        this.mqttClientService = mqttClientService;
        this.flowmeterLogMapper = flowmeterLogMapper;
    }
}

