/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.shuxi.bean.dto.MilldamCommandDto;
import com.shuxi.bean.dto.MilldamDto;
import com.shuxi.bean.entity.FlowmeterPumpCommandEntity;
import com.shuxi.bean.entity.OperateLogEntity;
import com.shuxi.bean.entity.WaterLevelValveUnion;
import com.shuxi.mapper.FlowmeterLogMapper;
import com.shuxi.mapper.FlowmeterPumpCommandMapper;
import com.shuxi.mapper.MilldamCommandMapper;
import com.shuxi.mapper.OperateLogMapper;
import com.shuxi.mapper.WaterLevelMapper;
import com.shuxi.mapper.WaterLevelValveUnionMapper;
import com.shuxi.service.MilldamService;
import com.shuxi.service.MqttClientService;
import com.shuxi.service.MqttMessageService;
import com.shuxi.util.HexStringUtil;
import com.shuxi.util.IdGenerator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class MqttClientServiceImpl
implements MqttClientService {
    private static final Logger log = LoggerFactory.getLogger(MqttClientServiceImpl.class);
    private final MilldamCommandMapper milldamCommandMapper;
    private final WaterLevelMapper waterLevelMapper;
    private final WaterLevelValveUnionMapper waterLevelValveUnionMapper;
    private final MqttMessageService mqttMessageService;
    private final MilldamService milldamService;
    private final OperateLogMapper operateLogMapper;
    private final FlowmeterPumpCommandMapper flowmeterPumpCommandMapper;
    private final FlowmeterLogMapper flowmeterLogMapper;
    private int latestQueryWaterLevelDay = 0;
    @Value(value="${spring.mqtt.topic}")
    private String topicName;
    @Value(value="${spring.mqtt.topic-jgs}")
    private String topicJgsName;
    private static final String thCompanyId = "6597";
    private static final String jgsCompanyId = "6618";

    @Async
    public void mqttSend(String code, Integer functionType, String userId, String userName, String companyId) {
        MilldamDto milldamDto = this.milldamService.selectById(code);
        MilldamCommandDto milldamCommandDto = this.milldamCommandMapper.selectByFunctionType(functionType);
        milldamCommandDto.setIdFour(milldamDto.getIdFour());
        String commandStr = this.commandJoint(milldamCommandDto);
        commandStr = commandStr.replace(" ", "");
        byte[] messageBytes = HexStringUtil.hexStringToBytes((String)commandStr);
        String topic = "";
        if (thCompanyId.equals(milldamDto.getCompanyId())) {
            topic = this.topicName;
        }
        if (jgsCompanyId.equals(milldamDto.getCompanyId())) {
            topic = this.topicJgsName;
        }
        for (int i = 0; i < 3; ++i) {
            this.mqttMessageService.sendToMqtt(topic, messageBytes);
            try {
                Thread.sleep(4000L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("============================ sleep\u88ab\u6253\u65ad\u4e86");
            }
        }
        if (functionType == 1 || functionType == 2 || functionType == 3) {
            Integer onOff = 0;
            if (functionType == 2) {
                onOff = 1;
            }
            this.insertOperateLog(onOff, userId, userName, companyId, milldamDto.getCode(), milldamDto.getCodeType(), milldamDto.getName(), "\u592a\u548c\u5927\u5c4f");
        }
    }

    private void insertOperateLog(Integer onOff, String userId, String userName, String companyId, String code, Integer codeType, String name, String clientName) {
        OperateLogEntity operateLog = new OperateLogEntity();
        operateLog.setId(String.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
        operateLog.setCtlCode(code);
        operateLog.setCtlType(codeType);
        operateLog.setCtlName(name);
        operateLog.setCtlFunctionType(onOff);
        operateLog.setUserId(userId);
        operateLog.setUserName(userName);
        operateLog.setCompanyId(companyId);
        operateLog.setOperateTime(new Date());
        operateLog.setClientName(clientName);
        this.operateLogMapper.insert((Object)operateLog);
    }

    public void mqttSendWaterLevels() {
        Collection idFours;
        if (LocalDateTime.now().getHour() == 1 && LocalDateTime.now().getDayOfMonth() != this.latestQueryWaterLevelDay) {
            log.info("------------------------------- \u67e5\u8be2\u6240\u6709\u6c34\u4f4d\u4eea\u7684\u9ad8\u5ea6");
            idFours = this.waterLevelMapper.getWaterLevelDevIds();
            this.latestQueryWaterLevelDay = LocalDateTime.now().getDayOfMonth();
        } else {
            String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.waterLevelValveUnionMapper).apply("to_char(start_time, 'YYYY-MM-DD')<={0} and to_char(end_time, 'YYYY-MM-DD')>={0}", new Object[]{now})).orderByAsc(WaterLevelValveUnion::getCreateTime)).list();
            idFours = list.stream().map(WaterLevelValveUnion::getWaterLevelIdFour).collect(Collectors.toSet());
            log.info("------------------------------- \u67e5\u8be2\u8054\u52a8\u7684\u6c34\u4f4d\u4eea\uff0cidFours={}", (Object)idFours);
        }
        MilldamCommandDto milldamCommandDto = this.milldamCommandMapper.selectByFunctionType(Integer.valueOf(17));
        for (String idFour : idFours) {
            this.mqttSendOneWaterLevel(idFour, milldamCommandDto);
            try {
                TimeUnit.MILLISECONDS.sleep(10000L);
            }
            catch (InterruptedException e) {
                log.error("========================= \u6c34\u4f4d\u4eea\u53d1\u9001\u6307\u4ee4\u5f02\u5e38");
                Thread.currentThread().interrupt();
            }
        }
    }

    public void mqttSendWaterLevel(String idFour) {
        MilldamCommandDto milldamCommandDto = this.milldamCommandMapper.selectByFunctionType(Integer.valueOf(17));
        this.mqttSendOneWaterLevel(idFour, milldamCommandDto);
    }

    private void mqttSendOneWaterLevel(String idFour, MilldamCommandDto milldamCommandDto) {
        milldamCommandDto.setIdFour(idFour);
        String commandStr = this.commandJoint(milldamCommandDto);
        log.info("------------------------ \u6c34\u4f4d\u4eea\u53d1\u9001\u6307\u4ee4commandStr={}", (Object)commandStr);
        commandStr = commandStr.replace(" ", "");
        byte[] messageBytes = HexStringUtil.hexStringToBytes((String)commandStr);
        this.mqttMessageService.sendToMqtt(this.topicName, messageBytes);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.mqttMessageService.sendToMqtt(this.topicName, messageBytes);
    }

    public void mqttSendFlowmeter(String code, Integer commandType) {
        FlowmeterPumpCommandEntity flowmeterPumpCommandEntity = this.flowmeterPumpCommandMapper.selectByCtlCode(code, commandType);
        String commandStr = flowmeterPumpCommandEntity.getCommand();
        commandStr = commandStr.replace(" ", "");
        byte[] messageBytes = HexStringUtil.hexStringToBytes((String)commandStr);
        this.mqttMessageService.sendToMqtt(this.topicName, messageBytes);
    }

    private String commandJoint(MilldamCommandDto milldamCommandDto) {
        StringBuilder stringBuilder = new StringBuilder();
        String blankStr = " ";
        stringBuilder.append(milldamCommandDto.getPacketHeaderOne());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getPacketHeaderTwo());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getIdOne());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getIdTwo());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getIdThree());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getIdFour());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getCommandOne());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getDataOne());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getDataTwo());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getDataThree());
        stringBuilder.append(blankStr);
        stringBuilder.append(milldamCommandDto.getDataFour());
        String verifyOne = HexStringUtil.hexSumString((String)stringBuilder.toString());
        stringBuilder.append(blankStr);
        stringBuilder.append(verifyOne);
        return stringBuilder.toString();
    }

    public MqttClientServiceImpl(MilldamCommandMapper milldamCommandMapper, WaterLevelMapper waterLevelMapper, WaterLevelValveUnionMapper waterLevelValveUnionMapper, MqttMessageService mqttMessageService, MilldamService milldamService, OperateLogMapper operateLogMapper, FlowmeterPumpCommandMapper flowmeterPumpCommandMapper, FlowmeterLogMapper flowmeterLogMapper) {
        this.milldamCommandMapper = milldamCommandMapper;
        this.waterLevelMapper = waterLevelMapper;
        this.waterLevelValveUnionMapper = waterLevelValveUnionMapper;
        this.mqttMessageService = mqttMessageService;
        this.milldamService = milldamService;
        this.operateLogMapper = operateLogMapper;
        this.flowmeterPumpCommandMapper = flowmeterPumpCommandMapper;
        this.flowmeterLogMapper = flowmeterLogMapper;
    }
}

