/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shuxi.bean.entity.ProcessingCtlEntity;
import com.shuxi.bean.entity.ProcessingCtlRecordEntity;
import com.shuxi.bean.vo.ProcessingEnvironmentVo;
import com.shuxi.bean.vo.ProcessingHistoricalTrendVo;
import com.shuxi.mapper.ProcessingCtlMapper;
import com.shuxi.service.ProcessingCtlRecordService;
import com.shuxi.service.ProcessingCtlService;
import com.shuxi.util.BigDecimalUtils;
import com.shuxi.util.DateUtils;
import com.shuxi.util.HttpRequestUtil;
import com.shuxi.util.IdGenerator;
import com.shuxi.util.JsonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ProcessingCtlServiceImpl
extends ServiceImpl<ProcessingCtlMapper, ProcessingCtlEntity>
implements ProcessingCtlService {
    private static final Logger log = LoggerFactory.getLogger(ProcessingCtlServiceImpl.class);
    @Value(value="${sny.username}")
    private String username;
    @Value(value="${sny.password}")
    private String password;
    @Value(value="${sny.url}")
    private String url;
    @Value(value="${sny.loginUrl}")
    private String loginUrl;
    @Value(value="${sny.getListUrl}")
    private String getListUrl;
    @Value(value="${sny.getDataUrl}")
    private String getDataUrl;
    private static final Integer thCompanyId = 6597;
    @Autowired
    private ProcessingCtlRecordService processingCtlRecordService;

    public ProcessingEnvironmentVo realTimeEnvironment(Integer companyId, String ctlName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProcessingCtlEntity::getCompanyId, (Object)companyId)).like(ProcessingCtlEntity::getName, (Object)ctlName)).eq(ProcessingCtlEntity::getDeleteFlag, (Object)0)).eq(ProcessingCtlEntity::getTaskFlag, (Object)0);
        List list = ((ProcessingCtlMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        ProcessingEnvironmentVo processingEnvironmentVo = new ProcessingEnvironmentVo();
        if (CollUtil.isEmpty((Collection)list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907");
            return processingEnvironmentVo;
        }
        String token = this.snyToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u767b\u5f55token");
            return processingEnvironmentVo;
        }
        for (ProcessingCtlEntity processingCtlEntity : list) {
            if (1 == processingCtlEntity.getType()) {
                this.setTemperatureAndHumidity(processingEnvironmentVo, processingCtlEntity.getId(), token);
            }
            if (2 != processingCtlEntity.getType()) continue;
            this.setWindSpeed(processingEnvironmentVo, processingCtlEntity.getId(), token);
        }
        return processingEnvironmentVo;
    }

    public void processingRecordTask() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProcessingCtlEntity::getCompanyId, (Object)thCompanyId)).eq(ProcessingCtlEntity::getDeleteFlag, (Object)0)).eq(ProcessingCtlEntity::getTaskFlag, (Object)0);
        List list = ((ProcessingCtlMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907");
            return;
        }
        String token = this.snyToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u767b\u5f55token");
            return;
        }
        ArrayList processingCtlRecordEntityList = new ArrayList();
        LocalDateTime now = LocalDateTime.now();
        for (ProcessingCtlEntity processingCtlEntity : list) {
            if (1 == processingCtlEntity.getType()) {
                this.temperatureAndHumidityTask(processingCtlRecordEntityList, processingCtlEntity.getId(), token, now);
            }
            if (2 != processingCtlEntity.getType()) continue;
            this.windSpeedTask(processingCtlRecordEntityList, processingCtlEntity.getId(), token, now);
        }
        this.processingCtlRecordService.saveBatch(processingCtlRecordEntityList);
    }

    public ProcessingHistoricalTrendVo historicalTrend(Integer companyId, String ctlName, String dataTime) {
        ProcessingHistoricalTrendVo processingHistoricalTrendVo = new ProcessingHistoricalTrendVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProcessingCtlEntity::getCompanyId, (Object)companyId)).like(ProcessingCtlEntity::getName, (Object)ctlName)).eq(ProcessingCtlEntity::getType, (Object)1)).eq(ProcessingCtlEntity::getDeleteFlag, (Object)0)).eq(ProcessingCtlEntity::getTaskFlag, (Object)0);
        List list = ((ProcessingCtlMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907");
            return processingHistoricalTrendVo;
        }
        ProcessingCtlEntity processingCtlEntity = (ProcessingCtlEntity)list.get(0);
        if (StringUtils.isBlank((CharSequence)dataTime)) {
            dataTime = DateUtils.daFormat((Date)new Date());
        }
        LocalDate date = LocalDate.parse(dataTime, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDateTime startOfDay = date.atStartOfDay();
        LocalDateTime endOfDay = date.atTime(23, 59, 59);
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ProcessingCtlRecordEntity::getCompanyId, (Object)companyId)).between(ProcessingCtlRecordEntity::getCreateTime, (Object)startOfDay, (Object)endOfDay)).eq(ProcessingCtlRecordEntity::getProcessingCtlId, (Object)processingCtlEntity.getId())).orderByAsc(ProcessingCtlRecordEntity::getCreateTime);
        List processingCtlRecordEntityList = this.processingCtlRecordService.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)processingCtlRecordEntityList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907\u6570\u636e");
            return processingHistoricalTrendVo;
        }
        ArrayList<String> xData = new ArrayList<String>();
        ArrayList<String> yTemperatureData = new ArrayList<String>();
        ArrayList<String> yHumidityData = new ArrayList<String>();
        for (ProcessingCtlRecordEntity processingCtlRecordEntity : processingCtlRecordEntityList) {
            xData.add(processingCtlRecordEntity.getCreateTime().format(DateTimeFormatter.ofPattern("HH:mm")));
            yTemperatureData.add(processingCtlRecordEntity.getTemperature());
            yHumidityData.add(processingCtlRecordEntity.getHumidity());
        }
        processingHistoricalTrendVo.setXData(xData);
        processingHistoricalTrendVo.setYTemperatureData(yTemperatureData);
        processingHistoricalTrendVo.setYHumidityData(yHumidityData);
        return processingHistoricalTrendVo;
    }

    public ProcessingHistoricalTrendVo windSpeedMonitoring(Integer companyId, String ctlName, String dataTime) {
        ProcessingHistoricalTrendVo processingHistoricalTrendVo = new ProcessingHistoricalTrendVo();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ProcessingCtlEntity::getCompanyId, (Object)companyId)).like(ProcessingCtlEntity::getName, (Object)ctlName)).eq(ProcessingCtlEntity::getType, (Object)2)).eq(ProcessingCtlEntity::getDeleteFlag, (Object)0)).eq(ProcessingCtlEntity::getTaskFlag, (Object)0);
        List list = ((ProcessingCtlMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907");
            return processingHistoricalTrendVo;
        }
        ProcessingCtlEntity processingCtlEntity = (ProcessingCtlEntity)list.get(0);
        if (StringUtils.isBlank((CharSequence)dataTime)) {
            dataTime = DateUtils.daFormat((Date)new Date());
        }
        LocalDate date = LocalDate.parse(dataTime, DateTimeFormatter.ISO_LOCAL_DATE);
        LocalDateTime startOfDay = date.atStartOfDay();
        LocalDateTime endOfDay = date.atTime(23, 59, 59);
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(ProcessingCtlRecordEntity::getCompanyId, (Object)companyId)).between(ProcessingCtlRecordEntity::getCreateTime, (Object)startOfDay, (Object)endOfDay)).eq(ProcessingCtlRecordEntity::getProcessingCtlId, (Object)processingCtlEntity.getId())).orderByAsc(ProcessingCtlRecordEntity::getCreateTime);
        List processingCtlRecordEntityList = this.processingCtlRecordService.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)processingCtlRecordEntityList)) {
            log.error("\u672a\u67e5\u8be2\u5230\u585e\u519c\u4e91\u8bbe\u5907\u6570\u636e");
            return processingHistoricalTrendVo;
        }
        ArrayList<String> xData = new ArrayList<String>();
        ArrayList<String> yWindSpeedData = new ArrayList<String>();
        for (ProcessingCtlRecordEntity processingCtlRecordEntity : processingCtlRecordEntityList) {
            xData.add(processingCtlRecordEntity.getCreateTime().format(DateTimeFormatter.ofPattern("HH:mm")));
            yWindSpeedData.add(processingCtlRecordEntity.getWindSpeed());
        }
        processingHistoricalTrendVo.setXData(xData);
        processingHistoricalTrendVo.setYWindSpeedData(yWindSpeedData);
        return processingHistoricalTrendVo;
    }

    private void windSpeedTask(List<ProcessingCtlRecordEntity> processingCtlRecordEntityList, String id, String token, LocalDateTime now) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String getDataUrlStr = this.url + this.getDataUrl;
        String result = HttpRequestUtil.newSendPost((String)getDataUrlStr, map, (String)"token", (String)token);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        try {
            Map jsonToBean = (Map)JsonUtil.getJsonToBean((String)result, Map.class);
            String name = jsonToBean.get("name").toString();
            if (!"\u98ce\u901f".equals(name)) {
                log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u7684\u8bbe\u5907\u4e0d\u5bf9\uff1a\u8fd4\u56de\u7684\u6570\u636e\u4e0d\u662f\u98ce\u901f");
                return;
            }
            String data = jsonToBean.get("data").toString();
            String[] split = data.split("  ");
            String windSpeed = "0.0";
            if (split.length == 7) {
                windSpeed = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[3] + split[4], 16)), (String)"10", (int)1);
            }
            ProcessingCtlRecordEntity processingCtlRecordEntity = new ProcessingCtlRecordEntity();
            processingCtlRecordEntity.setId(String.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
            processingCtlRecordEntity.setCompanyId(thCompanyId);
            processingCtlRecordEntity.setWindSpeed(windSpeed);
            processingCtlRecordEntity.setCreateTime(now);
            processingCtlRecordEntity.setProcessingCtlId(id);
            processingCtlRecordEntityList.add(processingCtlRecordEntity);
        }
        catch (Exception e) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    private void temperatureAndHumidityTask(List<ProcessingCtlRecordEntity> processingCtlRecordEntityList, String id, String token, LocalDateTime now) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String getDataUrlStr = this.url + this.getDataUrl;
        String result = HttpRequestUtil.newSendPost((String)getDataUrlStr, map, (String)"token", (String)token);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        try {
            Map jsonToBean = (Map)JsonUtil.getJsonToBean((String)result, Map.class);
            String name = jsonToBean.get("name").toString();
            if (!"\u6e29\u5ea6,\u6e7f\u5ea6".equals(name)) {
                log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u7684\u8bbe\u5907\u4e0d\u5bf9\uff1a\u8fd4\u56de\u7684\u6570\u636e\u4e0d\u662f\u6e29\u6e7f\u5ea6");
                return;
            }
            String data = jsonToBean.get("data").toString();
            String[] split = data.split("  ");
            String temperature = "0.0";
            String humidity = "0.0";
            if (split.length == 9) {
                temperature = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[3] + split[4], 16)), (String)"10", (int)1);
                humidity = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[5] + split[6], 16)), (String)"10", (int)1);
            }
            ProcessingCtlRecordEntity processingCtlRecordEntity = new ProcessingCtlRecordEntity();
            processingCtlRecordEntity.setId(String.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
            processingCtlRecordEntity.setCompanyId(thCompanyId);
            processingCtlRecordEntity.setTemperature(temperature);
            processingCtlRecordEntity.setHumidity(humidity);
            processingCtlRecordEntity.setCreateTime(now);
            processingCtlRecordEntity.setProcessingCtlId(id);
            processingCtlRecordEntityList.add(processingCtlRecordEntity);
        }
        catch (Exception e) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    private void setWindSpeed(ProcessingEnvironmentVo processingEnvironmentVo, String id, String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String getDataUrlStr = this.url + this.getDataUrl;
        String result = HttpRequestUtil.newSendPost((String)getDataUrlStr, map, (String)"token", (String)token);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        try {
            Map jsonToBean = (Map)JsonUtil.getJsonToBean((String)result, Map.class);
            String name = jsonToBean.get("name").toString();
            if (!"\u98ce\u901f".equals(name)) {
                log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u7684\u8bbe\u5907\u4e0d\u5bf9\uff1a\u8fd4\u56de\u7684\u6570\u636e\u4e0d\u662f\u98ce\u901f");
                return;
            }
            String data = jsonToBean.get("data").toString();
            String[] split = data.split("  ");
            String windSpeed = "0.0";
            if (split.length == 7) {
                windSpeed = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[3] + split[4], 16)), (String)"10", (int)1);
            }
            processingEnvironmentVo.setWindSpeed(windSpeed);
        }
        catch (Exception e) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    private void setTemperatureAndHumidity(ProcessingEnvironmentVo processingEnvironmentVo, String id, String token) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        String getDataUrlStr = this.url + this.getDataUrl;
        String result = HttpRequestUtil.newSendPost((String)getDataUrlStr, map, (String)"token", (String)token);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return;
        }
        try {
            Map jsonToBean = (Map)JsonUtil.getJsonToBean((String)result, Map.class);
            String name = jsonToBean.get("name").toString();
            if (!"\u6e29\u5ea6,\u6e7f\u5ea6".equals(name)) {
                log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u7684\u8bbe\u5907\u4e0d\u5bf9\uff1a\u8fd4\u56de\u7684\u6570\u636e\u4e0d\u662f\u6e29\u6e7f\u5ea6");
                return;
            }
            String data = jsonToBean.get("data").toString();
            String[] split = data.split("  ");
            String temperature = "0.0";
            String humidity = "0.0";
            if (split.length == 9) {
                temperature = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[3] + split[4], 16)), (String)"10", (int)1);
                humidity = BigDecimalUtils.div((String)String.valueOf(Integer.parseInt(split[5] + split[6], 16)), (String)"10", (int)1);
            }
            processingEnvironmentVo.setTemperature(temperature);
            processingEnvironmentVo.setHumidity(humidity);
        }
        catch (Exception e) {
            log.error("\u8bbe\u5907\u83b7\u53d6\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
    }

    private String snyToken() {
        String token = "";
        String loginUrlStr = this.url + this.loginUrl;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", this.username);
        map.put("password", this.password);
        String result = HttpRequestUtil.newSendPost((String)loginUrlStr, map);
        if (StringUtils.isBlank((CharSequence)result)) {
            log.error("\u585e\u519c\u4e91\u767b\u5f55\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return token;
        }
        try {
            Map jsonToBean = (Map)JsonUtil.getJsonToBean((String)result, Map.class);
            String code = jsonToBean.get("code").toString();
            if (!"0".equals(code)) {
                log.error("\u585e\u519c\u4e91\u767b\u5f55\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38\uff1a{}", jsonToBean.get("msg"));
                return token;
            }
            token = jsonToBean.get("token").toString();
        }
        catch (Exception e) {
            log.error("\u585e\u519c\u4e91\u767b\u5f55token\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return token;
    }
}

