/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.base.vo.PaginationVO;
import com.shuxi.bean.ca.ProcessingRecordCase;
import com.shuxi.bean.entity.ProcessingBreedEntity;
import com.shuxi.bean.entity.ProcessingRecordEntity;
import com.shuxi.bean.vo.ProcessingRecordChartsVo;
import com.shuxi.bean.vo.ProcessingRecordVo;
import com.shuxi.mapper.ProcessingBreedMapper;
import com.shuxi.mapper.ProcessingRecordMapper;
import com.shuxi.service.ProcessingRecordService;
import com.shuxi.util.DateUtils;
import com.shuxi.util.JsonUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessingRecordServiceImpl
extends ServiceImpl<ProcessingRecordMapper, ProcessingRecordEntity>
implements ProcessingRecordService {
    @Autowired
    private ProcessingRecordMapper processingRecordMapper;
    @Autowired
    private ProcessingBreedMapper processingBreedMapper;

    public List<ProcessingBreedEntity> processingBreedList(Integer companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProcessingBreedEntity::getCompanyId, (Object)companyId);
        List list = this.processingBreedMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    public void processingRecordAdd(ProcessingRecordCase processingRecordCase) {
        ProcessingRecordEntity processingRecordEntity = (ProcessingRecordEntity)JsonUtil.getJsonToBean((Object)processingRecordCase, ProcessingRecordEntity.class);
        processingRecordEntity.setId(UUID.randomUUID().toString());
        processingRecordEntity.setProcessingTime(DateUtils.stringToLocalDateTime((String)processingRecordCase.getProcessingTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        processingRecordEntity.setProcessingQuantity(new BigDecimal(processingRecordCase.getProcessingQuantity()));
        processingRecordEntity.setCreateTime(LocalDateTime.now());
        this.processingRecordMapper.insert((Object)processingRecordEntity);
    }

    public void processingRecordUpdate(ProcessingRecordCase processingRecordCase) {
        ProcessingRecordEntity processingRecordEntity = (ProcessingRecordEntity)((ProcessingRecordMapper)this.baseMapper).selectById((Serializable)((Object)processingRecordCase.getId()));
        if (ObjectUtil.isNotEmpty((Object)processingRecordEntity)) {
            processingRecordEntity = (ProcessingRecordEntity)JsonUtil.getJsonToBean((Object)processingRecordCase, ProcessingRecordEntity.class);
            processingRecordEntity.setProcessingTime(DateUtils.stringToLocalDateTime((String)processingRecordCase.getProcessingTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            processingRecordEntity.setProcessingQuantity(new BigDecimal(processingRecordCase.getProcessingQuantity()));
            processingRecordEntity.setProductionQuantity(new BigDecimal(processingRecordCase.getProductionQuantity()));
            processingRecordEntity.setUpdateTime(LocalDateTime.now());
            this.processingRecordMapper.updateById((Object)processingRecordEntity);
        }
    }

    public ProcessingRecordVo processingRecordDetail(String id) {
        ProcessingRecordEntity processingRecordEntity = (ProcessingRecordEntity)this.processingRecordMapper.selectById((Serializable)((Object)id));
        ProcessingRecordVo processingRecordVo = (ProcessingRecordVo)JsonUtil.getJsonToBean((Object)processingRecordEntity, ProcessingRecordVo.class);
        processingRecordVo.setProcessingStatus(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)processingRecordVo.getProductionQuantity())) {
            processingRecordVo.setProcessingStatus(Integer.valueOf(2));
        }
        return processingRecordVo;
    }

    public void processingRecordDelete(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String[] split = ids.split(",");
            ArrayList<String> strings = new ArrayList<String>(Arrays.asList(split));
            this.processingRecordMapper.deleteBatchIds(strings);
        }
    }

    public PageListVO<ProcessingRecordVo> processingRecordList(ProcessingRecordCase processingRecordCase) {
        Long pageIndex = (processingRecordCase.getCurrentPage() - 1L) * processingRecordCase.getPageSize();
        PageListVO pageListVO = new PageListVO();
        PaginationVO pagination = new PaginationVO();
        List list = this.processingRecordMapper.processingRecordList(pageIndex, processingRecordCase.getPageSize(), processingRecordCase.getProcessingBreedName(), processingRecordCase.getCompanyId());
        Integer count = this.processingRecordMapper.processingRecordCount(processingRecordCase.getProcessingBreedName(), processingRecordCase.getCompanyId());
        pagination.setCurrentPage(Long.valueOf(processingRecordCase.getCurrentPage()));
        pagination.setPageSize(Long.valueOf(processingRecordCase.getPageSize()));
        pagination.setTotal(count);
        pageListVO.setList(list);
        pageListVO.setPagination(pagination);
        return pageListVO;
    }

    public List<List<Object>> processingRecordCharts(Integer companyId) {
        String startTime = "00:00:00";
        Date dayEndTime = DateUtils.getDayEnd();
        Date pastStartTime = DateUtils.getFrontDay((Date)new Date(), (int)6);
        String pastStartTimeStr = DateUtils.dateToString((Date)pastStartTime, (String)"yyyy-MM-dd") + " " + startTime;
        Date finalPastStartTime = DateUtils.stringToDate((String)pastStartTimeStr);
        List getAllDays = DateUtils.getAllDayStrs((Date)finalPastStartTime, (Date)dayEndTime);
        List processingRecordChartsVos = this.processingRecordMapper.processingRecordCharts(companyId, LocalDateTimeUtil.parse((CharSequence)DateUtils.dateFormat((Date)finalPastStartTime), (String)"yyyy-MM-dd HH:mm:ss"), LocalDateTimeUtil.parse((CharSequence)DateUtils.dateFormat((Date)dayEndTime), (String)"yyyy-MM-dd HH:mm:ss"));
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        if (ObjectUtil.isNotEmpty((Object)getAllDays)) {
            for (String day : getAllDays) {
                ArrayList<String> objects = new ArrayList<String>();
                Optional<BigDecimal> value = processingRecordChartsVos.stream().filter(vo -> day.equals(vo.getMonthDay())).map(ProcessingRecordChartsVo::getTotalProduction).findFirst();
                String totalProduction = "0";
                if (value.isPresent()) {
                    totalProduction = value.get().toString();
                }
                objects.add(day);
                objects.add(totalProduction);
                list.add(objects);
            }
        }
        return list;
    }
}

