/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.shuxi.bean.entity.DeviceCountInfoEntity;
import com.shuxi.bean.entity.ProjectInfoEntity;
import com.shuxi.bean.entity.ProjectModelEntity;
import com.shuxi.mapper.ProjectModelMapper;
import com.shuxi.mapper.ProjectOverviewMapper;
import com.shuxi.service.ProjectOverviewService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProjectOverviewServiceImpl
implements ProjectOverviewService {
    private static final Logger log = LoggerFactory.getLogger(ProjectOverviewServiceImpl.class);
    private final ProjectOverviewMapper projectOverviewMapper;
    private final ProjectModelMapper projectModelMapper;

    public ProjectInfoEntity detail(Integer companyId) {
        ProjectInfoEntity projectOverview = this.projectOverviewMapper.getByCompanyId(companyId);
        return projectOverview;
    }

    public List<DeviceCountInfoEntity> deviceChart(Integer companyId) {
        List list = this.projectOverviewMapper.deviceChartByCompanyId(companyId);
        return list;
    }

    public List<ProjectModelEntity> query3DModel(Integer companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProjectModelEntity::getCompanyId, (Object)companyId);
        queryWrapper.lambda().orderByAsc(ProjectModelEntity::getOverlayOrder);
        List list = this.projectModelMapper.selectList((Wrapper)queryWrapper);
        return list;
    }

    public ProjectOverviewServiceImpl(ProjectOverviewMapper projectOverviewMapper, ProjectModelMapper projectModelMapper) {
        this.projectOverviewMapper = projectOverviewMapper;
        this.projectModelMapper = projectModelMapper;
    }
}

