/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.shuxi.base.vo.ActionResult;
import com.shuxi.bean.entity.TrackInfoHistoryEntity;
import com.shuxi.bean.entity.enumeration.MachineNum;
import com.shuxi.bean.vo.AddressKrmVo;
import com.shuxi.bean.vo.GpsTraceRecord;
import com.shuxi.bean.vo.TrackInfoCreateVo;
import com.shuxi.bean.vo.TrackInfoVo;
import com.shuxi.service.ScheduledService;
import com.shuxi.service.TransplanterService;
import com.shuxi.util.CoordinateTransformUtil;
import com.shuxi.util.DataException;
import com.shuxi.util.HttpSendUtil;
import com.shuxi.util.JsonUtil;
import com.shuxi.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduledServiceImpl
implements ScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ScheduledServiceImpl.class);
    private static String baseUrl;
    private final TransplanterService transplanterService;

    @Value(value="${farm.esUrl}")
    public void setBaseUrl(String baseUrl) {
        ScheduledServiceImpl.baseUrl = baseUrl;
    }

    public ActionResult insertTrackInfoByTest(Integer day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -day.intValue());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String startTime = sdf.format(calendar.getTime()) + " 00:00:00";
        String endTime = sdf.format(calendar.getTime()) + " 23:59:59";
        List trackInfoVoList = this.transplanterService.queryTrackList(startTime, endTime);
        log.info("startTime:{} endTime:{}  executionTime :{} ", new Object[]{startTime, endTime, new Date()});
        ArrayList insertList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((Collection)trackInfoVoList)) {
            for (TrackInfoVo infoVo : trackInfoVoList) {
                TrackInfoCreateVo createVo = new TrackInfoCreateVo();
                createVo = (TrackInfoCreateVo)JsonUtil.getJsonToBean((Object)infoVo, TrackInfoCreateVo.class);
                createVo.setD1101(infoVo.getDetails().getD1101() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1101());
                createVo.setD1102(infoVo.getDetails().getD1102() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1102());
                createVo.setD1103(infoVo.getDetails().getD1103() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1103());
                createVo.setD1104(infoVo.getDetails().getD1104() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1104());
                createVo.setD1105(infoVo.getDetails().getD1105() == null ? "" : infoVo.getDetails().getD1105());
                createVo.setD1106(infoVo.getDetails().getD1106() == null ? "" : infoVo.getDetails().getD1106());
                createVo.setD1107(infoVo.getDetails().getD1107() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1107());
                createVo.setD1108(infoVo.getDetails().getD1108() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1108());
                createVo.setD501(Integer.valueOf(infoVo.getDetails().getD501() == null ? 0 : infoVo.getDetails().getD501()));
                String point = "{\"type\":\"Point\",\"coordinates\":[" + createVo.getLon() + "," + createVo.getLat() + "]}";
                createVo.setCentral_point(point);
                insertList.add(createVo);
            }
        }
        if (StringUtil.isNotEmpty((Collection)insertList)) {
            for (TrackInfoCreateVo createVo : insertList) {
                this.transplanterService.insertBatch(createVo);
            }
        }
        log.info("======================\u63d2\u5165\u5386\u53f2\u8f68\u8ff9\u6210\u529f\uff01\u603b\u5171\u63d2\u5165\u3010" + insertList.size() + "\u3011\u6761\u6570\u636e========================");
        return ActionResult.success((Object)trackInfoVoList);
    }

    public ActionResult insertTransplantBySecond(String body) {
        Boolean flag;
        log.info("\u8054\u9002\u63d2\u79e7\u673a\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u519c\u673a\u8f68\u8ff9" + body);
        List insertList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)body)) {
            insertList = JSONArray.parseArray((String)body, TrackInfoCreateVo.class);
        }
        if (StringUtil.isNotEmpty((Collection)insertList) && (flag = this.checkDate(MachineNum.LS.getValue(), (TrackInfoCreateVo)insertList.get(0))).booleanValue()) {
            for (TrackInfoCreateVo infoCreateVo : insertList) {
                this.transplanterService.insertBatch(infoCreateVo);
            }
            log.info("======================\u8054\u9002\u63d2\u79e7\u673a\u63d2\u5165\u5386\u53f2\u8f68\u8ff9\u6210\u529f\uff01\u603b\u5171\u63d2\u5165\u3010" + insertList.size() + "\u3011\u6761\u6570\u636e========================");
        }
        return ActionResult.success();
    }

    public Boolean checkDate(String sn, TrackInfoCreateVo createVo) {
        Boolean flag = true;
        TrackInfoHistoryEntity historyEntity = this.transplanterService.queryDataByTime(sn);
        if (historyEntity != null && historyEntity.getSn().equals(createVo.getSn()) && historyEntity.getLat().equals(createVo.getLat()) && historyEntity.getLon().equals(createVo.getLon())) {
            flag = false;
        }
        return flag;
    }

    public ActionResult insertAddressAll(String startTime, String endTime, String machineNo) {
        String s1 = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JSONArray array = new JSONArray();
        List trackList = this.transplanterService.queryTrackList(startTime, endTime);
        if (StringUtil.isNotEmpty((Collection)trackList)) {
            List filterList = trackList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TrackInfoVo>(Comparator.comparing(TrackInfoVo::getMsgtime))), ArrayList::new));
            int partialLimit = 400;
            int limit = (filterList.size() + partialLimit - 1) / partialLimit;
            List finalList = filterList;
            List splitList = ((Stream)Stream.iterate(0, n -> n + 1).limit(limit).parallel()).map(a -> ((Stream)finalList.stream().skip((long)a.intValue() * (long)partialLimit).limit(partialLimit).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
            if (StringUtil.isNotEmpty(splitList)) {
                for (int i = 0; i < splitList.size(); ++i) {
                    List detailList = (List)splitList.get(i);
                    if (!StringUtil.isNotEmpty((Collection)detailList)) continue;
                    this.insertAddressKEM(detailList);
                }
            }
        }
        return ActionResult.success((String)s1);
    }

    private String insertAddressKEM(List<TrackInfoVo> filterList) {
        String result = "";
        JSONArray array = new JSONArray();
        JSONArray jsonArray = new JSONArray();
        filterList.stream().forEach(t -> {
            JSONObject js = new JSONObject();
            js.put("gpsTime", (Object)t.getMsgtime());
            js.put("imei", (Object)t.getSn());
            js.put("gpsSpeed", (Object)t.getSpeed());
            double[] lonArr = CoordinateTransformUtil.wgs84tobd09((double)t.getLon().doubleValue(), (double)t.getLat().doubleValue());
            js.put("lng", (Object)lonArr[0]);
            js.put("lat", (Object)lonArr[1]);
            array.add((Object)js);
        });
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        AtomicReference jsonIt = new AtomicReference();
        AtomicReference json = new AtomicReference();
        AtomicReference parseTime = new AtomicReference();
        array.forEach(it -> {
            jsonIt.set((JSONObject)it);
            json.set(new JSONObject());
            parseTime.set(LocalDateTime.parse(((JSONObject)jsonIt.get()).getString("gpsTime"), formatter));
            ((JSONObject)json.get()).put("id", (Object)(((LocalDateTime)parseTime.get()).toInstant(ZoneOffset.ofHours(8)).toEpochMilli() + ((JSONObject)jsonIt.get()).getString("imei")));
            ((JSONObject)json.get()).put("s", (Object)((JSONObject)jsonIt.get()).getString("gpsSpeed"));
            ((JSONObject)json.get()).put("l", (Object)(((JSONObject)jsonIt.get()).getString("lat") + "," + ((JSONObject)jsonIt.get()).getString("lng")));
            ((JSONObject)json.get()).put("m", (Object)((JSONObject)jsonIt.get()).getString("imei"));
            ((JSONObject)json.get()).put("t", (Object)((LocalDateTime)parseTime.get()).toEpochSecond(ZoneOffset.ofHours(8)));
            ((JSONObject)json.get()).put("r", (Object)1);
            ((JSONObject)json.get()).put("cid", (Object)"6597");
            jsonArray.add(json.get());
        });
        if (jsonArray.size() > 0) {
            result = ScheduledServiceImpl.syncES((JSONArray)jsonArray);
        }
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject obj = JSONObject.parseObject((String)result);
            result = obj.get((Object)"resCode") == null ? "" : obj.get((Object)"resCode").toString();
        }
        return result;
    }

    private static String syncES(JSONArray array) {
        String s1 = null;
        String url = baseUrl + "gps/machineTrace";
        try {
            s1 = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)array.toJSONString(), null);
        }
        catch (IOException e) {
            log.error("\u8054\u9002GPS\u5b9e\u65f6\u4f4d\u7f6e\u63a8\u9001\uff1a" + e.getMessage());
        }
        log.error("\u8054\u9002GPS\u5b9e\u65f6\u4f4d\u7f6e\u63a8\u9001\u7ed3\u679c\uff1a" + s1);
        return s1;
    }

    public ActionResult queryTransplantByEs(String startTime, String endTime, String machineNo) {
        try {
            List list = Lists.newArrayList();
            List<Object> ids = Lists.newArrayList();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startDate = format.parse(startTime);
            Date endDate = format.parse(endTime);
            long start_time = startDate.getTime() / 1000L;
            long end_time = endDate.getTime() / 1000L;
            String url = "http://api.shuxitech.com/farm_es/gps/trace/" + machineNo + "?startTime=" + start_time + "&endTime=" + end_time;
            String result = HttpSendUtil.sendHttpGet((String)url);
            if (StringUtil.isNotEmpty((String)result)) {
                String resData;
                JSONObject obj = JSON.parseObject((String)result);
                String string = resData = obj.get((Object)"resData") == null ? "" : obj.get((Object)"resData").toString();
                if (StringUtil.isNotEmpty((String)resData)) {
                    String listObj;
                    JSONObject jsonObject = JSON.parseObject((String)resData);
                    String string2 = listObj = jsonObject.get((Object)"list") == null ? "" : jsonObject.get((Object)"list").toString();
                    if (StringUtil.isNotEmpty((String)listObj)) {
                        JSONArray array = JSONArray.parseArray((String)listObj);
                        list = array.toJavaList(GpsTraceRecord.class);
                    }
                }
            }
            if (StringUtil.isNotEmpty((Collection)list)) {
                ids = list.stream().map(t -> t.getId()).collect(Collectors.toList());
                log.info("========esid:" + JSON.toJSONString((Object)ids));
            }
            return ActionResult.success((Object)ids);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("");
            return ActionResult.fail((String)"");
        }
    }

    public ActionResult insertTransplantByKEM(String startTime, String endTime) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List addressKrmVoList = this.transplanterService.queryAddressByKEM(startTime, endTime);
        ArrayList insertList = Lists.newArrayList();
        try {
            if (StringUtil.isNotEmpty((Collection)addressKrmVoList)) {
                for (AddressKrmVo addressKrmVo : addressKrmVoList) {
                    TrackInfoCreateVo createVo = new TrackInfoCreateVo();
                    createVo.setAtz(addressKrmVo.getHeading());
                    createVo.setLat(addressKrmVo.getLat());
                    createVo.setLon(addressKrmVo.getLng());
                    createVo.setSpeed(addressKrmVo.getSpeed());
                    createVo.setMsgtime(df.parse(addressKrmVo.getTs()));
                    String point = "{\"type\":\"Point\",\"coordinates\":[" + addressKrmVo.getLng() + "," + addressKrmVo.getLat() + "]}";
                    createVo.setCentral_point(point);
                    createVo.setSn(MachineNum.KEM.getValue());
                    insertList.add(createVo);
                }
            }
            if (StringUtil.isNotEmpty((Collection)insertList)) {
                for (TrackInfoCreateVo createVo : insertList) {
                    this.transplanterService.insertBatch(createVo);
                }
            }
            log.info("======================\u63d2\u5165\u5386\u53f2\u8f68\u8ff9\u6210\u529f\uff01\u603b\u5171\u63d2\u5165\u3010" + insertList.size() + "\u3011\u6761\u6570\u636e========================");
            return ActionResult.success();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("");
            throw new DataException(e.getMessage());
        }
    }

    public ActionResult createTransplantByKEM(String body) {
        log.info("\u5361\u5c14\u66fc\u519c\u673a\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u8f68\u8ff9:" + body);
        List insertList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)body)) {
            insertList = JSONArray.parseArray((String)body, TrackInfoCreateVo.class);
        }
        try {
            Boolean flag;
            if (StringUtil.isNotEmpty((Collection)insertList) && (flag = this.checkDate(MachineNum.KEM.getValue(), (TrackInfoCreateVo)insertList.get(0))).booleanValue()) {
                for (TrackInfoCreateVo infoCreateVo : insertList) {
                    this.transplanterService.insertBatch(infoCreateVo);
                }
                log.info("======================\u5361\u5c14\u66fc\u519c\u673a\u63d2\u5165\u5386\u53f2\u8f68\u8ff9\u6210\u529f\uff01\u603b\u5171\u63d2\u5165\u3010" + insertList.size() + "\u3011\u6761\u6570\u636e========================");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u5361\u5c14\u66fc\u519c\u673a\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u5361\u5c14\u66fc\u519c\u673a\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return ActionResult.success();
    }

    public ActionResult createTransplantByZYNJ(String body) {
        List insertList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((String)body)) {
            insertList = JSONArray.parseArray((String)body, TrackInfoCreateVo.class);
        }
        try {
            Boolean flag;
            if (StringUtil.isNotEmpty((Collection)insertList) && (flag = this.checkDate(((TrackInfoCreateVo)insertList.get(0)).getSn(), (TrackInfoCreateVo)insertList.get(0))).booleanValue()) {
                for (TrackInfoCreateVo createVo : insertList) {
                    String point = "{\"type\":\"Point\",\"coordinates\":[" + createVo.getLon() + "," + createVo.getLat() + "]}";
                    createVo.setCentral_point(point);
                    this.transplanterService.insertBatch(createVo);
                }
                log.info("======================\u63d2\u5165\u5386\u53f2\u8f68\u8ff9\u6210\u529f\uff01\u603b\u5171\u63d2\u5165\u3010" + insertList.size() + "\u3011\u6761\u6570\u636e========================");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u4e2d\u539f\u519c\u673a\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u5b9a\u65f6\u4efb\u52a1\u63d2\u5165\u4e2d\u539f\u519c\u673a\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        return ActionResult.success();
    }

    private ActionResult insertAddress() {
        List list = this.transplanterService.queryTrackDetail();
        ArrayList insertList = Lists.newArrayList();
        if (StringUtil.isNotEmpty((Collection)list)) {
            for (TrackInfoVo infoVo : list) {
                TrackInfoCreateVo createVo = new TrackInfoCreateVo();
                createVo = (TrackInfoCreateVo)JsonUtil.getJsonToBean((Object)infoVo, TrackInfoCreateVo.class);
                createVo.setD1101(infoVo.getDetails().getD1101() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1101());
                createVo.setD1102(infoVo.getDetails().getD1102() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1102());
                createVo.setD1103(infoVo.getDetails().getD1103() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1103());
                createVo.setD1104(infoVo.getDetails().getD1104() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1104());
                createVo.setD1105(infoVo.getDetails().getD1105() == null ? "" : infoVo.getDetails().getD1105());
                createVo.setD1106(infoVo.getDetails().getD1106() == null ? "" : infoVo.getDetails().getD1106());
                createVo.setD1107(infoVo.getDetails().getD1107() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1107());
                createVo.setD1108(infoVo.getDetails().getD1108() == null ? BigDecimal.ZERO : infoVo.getDetails().getD1108());
                createVo.setD501(Integer.valueOf(infoVo.getDetails().getD501() == null ? 0 : infoVo.getDetails().getD501()));
                String point = "{\"type\":\"Point\",\"coordinates\":[" + createVo.getLon() + "," + createVo.getLat() + "]}";
                createVo.setCentral_point(point);
                insertList.add(createVo);
            }
        }
        return null;
    }

    public ScheduledServiceImpl(TransplanterService transplanterService) {
        this.transplanterService = transplanterService;
    }
}

