/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.shuxi.base.vo.PageListVO;
import com.shuxi.base.vo.PaginationVO;
import com.shuxi.bean.entity.TrackInfoHistoryEntity;
import com.shuxi.bean.entity.enumeration.MachineNum;
import com.shuxi.bean.vo.AddressKrmVo;
import com.shuxi.bean.vo.DeviceCountVo;
import com.shuxi.bean.vo.DeviceInfoVo;
import com.shuxi.bean.vo.TrackInfoCreateVo;
import com.shuxi.bean.vo.TrackInfoVo;
import com.shuxi.bean.vo.WorkInfoVo;
import com.shuxi.bean.vo.WorkListVo;
import com.shuxi.bean.vo.WorkQueryVo;
import com.shuxi.mapper.TransplanterMapper;
import com.shuxi.service.TransplanterService;
import com.shuxi.util.CoordinateTransformUtil;
import com.shuxi.util.DataException;
import com.shuxi.util.HttpSendUtil;
import com.shuxi.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TransplanterServiceImpl
implements TransplanterService {
    private static final Logger log = LoggerFactory.getLogger(TransplanterServiceImpl.class);
    private final RedisTemplate redisTemplate;
    private static final String LIANSHI_BASEURL = "http://openapi.allynav.cn/v4";
    private static final String TOKEN_URL = "/api/v4/token/get";
    private static final String TRACK_URL = "/api/v4/track/list";
    private static final String TRACK_NOW_URL = "/api/v4/track/detail";
    private static final String STATISTIC_URL = "/api/area/statistic_shifei";
    private static final String DEVICE_LIST_URL = "/api/v4/device/list";
    private static final String DEVICE_DETAIL_URL = "/api/v4/device/detail";
    private static final String DEVICE_COUNT_URL = "/api/device/online_stat_statistic";
    private static final String WORK_LIST_URL = "/api/v4/work/list";
    private static final String WORK_DETAIL_URL = "/api/v4/work/details_list";
    private static final String DURATION_SN_AREA_URL = "/api/area/duration_sn_area";
    private static final String WORK_CALENDAR_URL = "/api/work/calendar";
    private static final String DURATION_AREA_URL = "/api/area/duration_area";
    private static final String KRM_TRANSPLANT_URL = "https://opendata.kalman-navigation.com/open/api/v2/trace/listByTime";
    @Value(value="${transplant.app_key}")
    private String app_key;
    @Value(value="${transplant.app_secret}")
    private String app_secret;
    private static final String accessToken = "accessToken";
    private static final String mdsToken01 = "mdsToken01";
    private static final String mdsToken02 = "mdsToken02";
    private final TransplanterMapper transplanterMapper;
    @Value(value="${tq.apikey}")
    private String apikey;
    @Value(value="${tq.url}")
    private String tq_url;

    public String getToken() {
        try {
            String token = "";
            String key = "accessToken";
            boolean flag = this.redisTemplate.hasKey((Object)key);
            if (flag) {
                token = this.redisTemplate.opsForValue().get((Object)key).toString();
                return token;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("app_key", this.app_key);
            params.put("app_secret", this.app_secret);
            String url = "http://openapi.allynav.cn/v4/api/v4/token/get";
            String result = HttpUtil.post((String)url, params);
            if (StringUtil.isNotEmpty((String)result)) {
                JSONObject obj = this.checkData(result, url);
                String string = token = obj.get((Object)"token") == null ? "" : obj.get((Object)"token").toString();
                if (StringUtil.isNotEmpty((String)token)) {
                    String objValue = token;
                    this.redisTemplate.opsForValue().set((Object)"accessToken", (Object)objValue);
                    this.redisTemplate.expire((Object)"accessToken", 1L, TimeUnit.DAYS);
                }
            }
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u8054\u9002\u519c\u673atoken\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u83b7\u53d6token\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
    }

    public List<TrackInfoVo> queryTrackList(String startTime, String endTime) {
        try {
            List listVos = Lists.newArrayList();
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date startDate = format.parse(startTime);
            Date endDate = format.parse(endTime);
            String token = this.getToken();
            HashMap<String, Object> param = new HashMap<String, Object>();
            long start_time = startDate.getTime();
            long end_time = endDate.getTime();
            param.put("start_time", start_time);
            param.put("end_time", end_time);
            param.put("sn", MachineNum.LS.getValue());
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("token", token);
            String url = "http://openapi.allynav.cn/v4/api/v4/track/list";
            String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
            if (StringUtil.isNotEmpty((String)result)) {
                String code;
                JSONObject obj = JSON.parseObject((String)result);
                log.info("\u83b7\u53d6\u8f68\u8ff9\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\uff1a" + obj);
                String string = code = obj.get((Object)"code") == null ? "" : obj.get((Object)"code").toString();
                if (StringUtil.isNotEmpty((String)code) && "200".equals(code)) {
                    String data;
                    String string2 = data = obj.get((Object)"data") == null ? "" : obj.get((Object)"data").toString();
                    if (StringUtil.isNotEmpty((String)data)) {
                        String list;
                        JSONObject dataObj = JSON.parseObject((String)data);
                        String string3 = list = dataObj.get((Object)"list") == null ? "" : dataObj.get((Object)"list").toString();
                        if (StringUtil.isNotEmpty((String)list)) {
                            JSONArray jsonArray = JSONArray.parseArray((String)list);
                            listVos = jsonArray.toJavaList(TrackInfoVo.class);
                        }
                    }
                } else {
                    String msg = obj.get((Object)"message") == null ? "" : obj.get((Object)"message").toString();
                    log.error("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + msg);
                    throw new DataException("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
                }
            }
            return listVos;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
            throw new DataException("\u83b7\u53d6\u8f68\u8ff9\u5217\u8868\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
    }

    public PageListVO<DeviceInfoVo> queryDeviceList(Integer page, Integer limit) {
        PageListVO pageListVO = new PageListVO();
        List listVo = Lists.newArrayList();
        PaginationVO pagination = new PaginationVO();
        pagination.setCurrentPage(Long.valueOf(page.longValue()));
        pagination.setPageSize(Long.valueOf(limit.longValue()));
        String token = this.getToken();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("page", page);
        param.put("limit", limit);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        String url = "http://openapi.allynav.cn/v4/api/v4/device/list";
        String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
        log.info("\u8bbe\u5907\u5217\u8868\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject dataObj = this.checkData(result, url);
            String rows = dataObj.get((Object)"rows") == null ? "" : dataObj.get((Object)"rows").toString();
            String total = dataObj.get((Object)"total") == null ? "0" : dataObj.get((Object)"total").toString();
            pagination.setTotal(Integer.valueOf(total));
            if (StringUtil.isNotEmpty((String)rows)) {
                JSONArray jsonArray = JSONArray.parseArray((String)rows);
                listVo = jsonArray.toJavaList(DeviceInfoVo.class);
            }
        }
        pageListVO.setList(listVo);
        pageListVO.setPagination(pagination);
        return pageListVO;
    }

    public DeviceInfoVo queryDeviceDetail(String sn) {
        JSONObject dataObj;
        DeviceInfoVo infoVo = new DeviceInfoVo();
        String token = this.getToken();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sn", sn);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        String url = "http://openapi.allynav.cn/v4/api/v4/device/detail";
        String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
        log.info("\u8bbe\u5907\u8be6\u60c5\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
        if (StringUtil.isNotEmpty((String)result) && StringUtil.isNotEmpty((Map)(dataObj = this.checkData(result, url)))) {
            infoVo = (DeviceInfoVo)JSONObject.toJavaObject((JSON)dataObj, DeviceInfoVo.class);
        }
        return infoVo;
    }

    public List<TrackInfoVo> queryTrackDetail() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            List infoVoList = Lists.newArrayList();
            String token = this.getToken();
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("token", token);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("sn", MachineNum.LS.getValue());
            String url = "http://openapi.allynav.cn/v4/api/v4/track/detail";
            String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
            log.info("\u5b9e\u65f6\u8f68\u8ff9\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
            if (StringUtil.isNotEmpty((String)result)) {
                String data;
                JSONObject dataObj = this.checkData(result, url);
                String string = data = dataObj.get((Object)"list") == null ? "" : dataObj.get((Object)"list").toString();
                if (StringUtil.isNotEmpty((String)data)) {
                    JSONArray array = JSON.parseArray((String)data);
                    infoVoList = array.toJavaList(TrackInfoVo.class);
                }
            }
            TrackInfoHistoryEntity historyEntity = this.queryDataByTime(MachineNum.LS.getValue());
            TrackInfoVo infoVo = (TrackInfoVo)infoVoList.get(0);
            if (historyEntity.getMsgTime().equals(df.parse(infoVo.getMsgtime())) && historyEntity.getLat().equals(infoVo.getLat()) && historyEntity.getLon().equals(infoVo.getLon())) {
                for (TrackInfoVo trackInfoVo : infoVoList) {
                    trackInfoVo.setSpeed(BigDecimal.ZERO);
                }
            }
            return infoVoList;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u5b9e\u65f6\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
            throw new DataException("\u83b7\u53d6\u5b9e\u65f6\u8f68\u8ff9\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
    }

    public DeviceCountVo queryDeviceCount() {
        JSONObject dataObj;
        DeviceCountVo countVo = new DeviceCountVo();
        String token = this.getToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        String url = "http://openapi.allynav.cn/v4/api/device/online_stat_statistic";
        String result = ((HttpRequest)HttpRequest.post((String)url).addHeaders(header)).execute().body();
        log.info("\u8bbe\u5907\u72b6\u6001\u7edf\u8ba1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
        if (StringUtil.isNotEmpty((String)result) && StringUtil.isNotEmpty((Map)(dataObj = this.checkData(result, url)))) {
            countVo = (DeviceCountVo)JSONObject.toJavaObject((JSON)dataObj, DeviceCountVo.class);
        }
        return countVo;
    }

    public PageListVO<WorkInfoVo> queryWorkInfoList(WorkQueryVo queryVo) {
        PageListVO pageListVO = new PageListVO();
        List listVo = Lists.newArrayList();
        PaginationVO paginationVO = new PaginationVO();
        String token = this.getToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("device_sn", MachineNum.LS.getValue());
        param.put("begin_ts", queryVo.getBegin_ts());
        param.put("end_ts", queryVo.getEnd_ts());
        param.put("page", queryVo.getPage());
        param.put("limit", queryVo.getLimit());
        String url = "http://openapi.allynav.cn/v4/api/v4/work/list";
        String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
        if (StringUtil.isNotEmpty((String)result)) {
            WorkListVo workListVo;
            log.info("\u4f5c\u4e1a\u5217\u8868\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
            JSONObject dataObj = this.checkData(result, url);
            if (StringUtil.isNotEmpty((Map)dataObj) && StringUtil.isNotNull((Object)(workListVo = (WorkListVo)JSONObject.toJavaObject((JSON)dataObj, WorkListVo.class)))) {
                listVo = workListVo.getList();
                paginationVO.setTotal(workListVo.getCount());
            }
        }
        paginationVO.setCurrentPage(Long.valueOf(queryVo.getPage().longValue()));
        paginationVO.setPageSize(Long.valueOf(queryVo.getLimit().longValue()));
        pageListVO.setList(listVo);
        pageListVO.setPagination(paginationVO);
        return pageListVO;
    }

    public PageListVO<WorkInfoVo> queryWorkInfoDetailList(WorkQueryVo queryVo) {
        PageListVO pageListVO = new PageListVO();
        List listVo = Lists.newArrayList();
        PaginationVO paginationVO = new PaginationVO();
        String token = this.getToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", token);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("device_sn", MachineNum.LS.getValue());
        param.put("begin_ts", queryVo.getBegin_ts());
        param.put("end_ts", queryVo.getEnd_ts());
        param.put("page", queryVo.getPage());
        param.put("limit", queryVo.getLimit());
        String url = "http://openapi.allynav.cn/v4/api/v4/work/details_list";
        String result = ((HttpRequest)HttpRequest.get((String)url).form(param).addHeaders(header)).execute().body();
        if (StringUtil.isNotEmpty((String)result)) {
            WorkListVo workListVo;
            log.info("\u4f5c\u4e1a\u8be6\u60c5\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.parseObject((String)result));
            JSONObject dataObj = this.checkData(result, url);
            if (StringUtil.isNotEmpty((Map)dataObj) && StringUtil.isNotNull((Object)(workListVo = (WorkListVo)JSONObject.toJavaObject((JSON)dataObj, WorkListVo.class)))) {
                listVo = workListVo.getList();
                paginationVO.setTotal(workListVo.getCount());
            }
        }
        paginationVO.setCurrentPage(Long.valueOf(queryVo.getPage().longValue()));
        paginationVO.setPageSize(Long.valueOf(queryVo.getLimit().longValue()));
        pageListVO.setList(listVo);
        pageListVO.setPagination(paginationVO);
        return pageListVO;
    }

    public void insertBatch(TrackInfoCreateVo createVo) {
        this.transplanterMapper.insertBatch(createVo);
    }

    public List<AddressKrmVo> queryAddressByKEM(String startTime, String endTime) {
        List list = Lists.newArrayList();
        try {
            String result;
            PostMethod postMethod = new PostMethod("https://opendata.kalman-navigation.com/open/api/v2/trace/listByTime");
            postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            postMethod.setRequestHeader("Authorization", "OKPABsYCCizzC36bAYFDRmAV6mvveA58miOg");
            NameValuePair[] data = new NameValuePair[]{new NameValuePair("startTime", startTime), new NameValuePair("endTime", endTime), new NameValuePair("uuid", MachineNum.KEM.getValue())};
            postMethod.setRequestBody(data);
            HttpClient httpClient = new HttpClient();
            int response = httpClient.executeMethod((HttpMethod)postMethod);
            if (response == 200 && StringUtil.isNotEmpty((String)(result = postMethod.getResponseBodyAsString()))) {
                String dataStr;
                JSONObject obj = JSON.parseObject((String)result);
                String string = dataStr = obj.get((Object)"data") == null ? "" : obj.get((Object)"data").toString();
                if (StringUtil.isNotEmpty((String)dataStr)) {
                    JSONArray array = JSON.parseArray((String)dataStr);
                    list = array.toJavaList(AddressKrmVo.class);
                    log.info("=============\u83b7\u53d6\u5361\u5c14\u66fc\u8f68\u8ff9\u6570\u636e\uff1a" + array + "================");
                }
            }
            log.info("=========================\u5361\u5c14\u66fc\u8f68\u8ff9\u67e5\u8be2\u63a5\u53e3\u5171\uff1a\u3010" + list.size() + "\u3011\u6761\u6570\u636e\uff01");
            if (list.size() > 0) {
                int partialLimit = 400;
                int limit = (list.size() + partialLimit - 1) / partialLimit;
                List finalList = list;
                List splitList = ((Stream)Stream.iterate(0, n -> n + 1).limit(limit).parallel()).map(a -> ((Stream)finalList.stream().skip((long)a.intValue() * (long)partialLimit).limit(partialLimit).parallel()).collect(Collectors.toList())).collect(Collectors.toList());
                if (StringUtil.isNotEmpty(splitList)) {
                    String code = "";
                    for (int i = 0; i < splitList.size(); ++i) {
                        List detailList = (List)splitList.get(i);
                        if (!StringUtil.isNotEmpty((Collection)detailList)) continue;
                        List filterList = detailList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AddressKrmVo>(Comparator.comparing(AddressKrmVo::getTs))), ArrayList::new));
                        this.insertAddressKEM(filterList);
                    }
                }
            }
            return list;
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42\u5f02\u5e38" + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public TrackInfoHistoryEntity queryDataByTime(String sn) {
        TrackInfoHistoryEntity entity = this.transplanterMapper.queryDataByTime(sn);
        return entity;
    }

    private String insertAddressKEM(List<AddressKrmVo> filterList) {
        String result = "";
        JSONArray array = new JSONArray();
        JSONArray jsonArray = new JSONArray();
        filterList.stream().forEach(t -> {
            JSONObject js = new JSONObject();
            js.put("gpsTime", (Object)t.getTs());
            js.put("imei", (Object)"015122410874");
            js.put("gpsSpeed", (Object)t.getSpeed());
            double[] lonArr = CoordinateTransformUtil.wgs84tobd09((double)t.getLng().doubleValue(), (double)t.getLat().doubleValue());
            js.put("lng", (Object)lonArr[0]);
            js.put("lat", (Object)lonArr[1]);
            array.add((Object)js);
        });
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        AtomicReference jsonIt = new AtomicReference();
        AtomicReference json = new AtomicReference();
        AtomicReference parseTime = new AtomicReference();
        array.forEach(it -> {
            jsonIt.set((JSONObject)it);
            json.set(new JSONObject());
            parseTime.set(LocalDateTime.parse(((JSONObject)jsonIt.get()).getString("gpsTime"), formatter));
            ((JSONObject)json.get()).put("id", (Object)(((LocalDateTime)parseTime.get()).toInstant(ZoneOffset.ofHours(8)).toEpochMilli() + ((JSONObject)jsonIt.get()).getString("imei")));
            ((JSONObject)json.get()).put("s", (Object)((JSONObject)jsonIt.get()).getString("gpsSpeed"));
            ((JSONObject)json.get()).put("l", (Object)(((JSONObject)jsonIt.get()).getString("lat") + "," + ((JSONObject)jsonIt.get()).getString("lng")));
            ((JSONObject)json.get()).put("m", (Object)((JSONObject)jsonIt.get()).getString("imei"));
            ((JSONObject)json.get()).put("t", (Object)((LocalDateTime)parseTime.get()).toEpochSecond(ZoneOffset.ofHours(8)));
            ((JSONObject)json.get()).put("r", (Object)1);
            ((JSONObject)json.get()).put("cid", (Object)"6597");
            jsonArray.add(json.get());
        });
        if (jsonArray.size() > 0) {
            result = TransplanterServiceImpl.syncES((JSONArray)jsonArray);
        }
        if (StringUtil.isNotEmpty((String)result)) {
            JSONObject obj = JSONObject.parseObject((String)result);
            result = obj.get((Object)"resCode") == null ? "" : obj.get((Object)"resCode").toString();
        }
        return result;
    }

    private static String syncES(JSONArray array) {
        String s1 = null;
        String url = "http://api.shuxitech.com/farm_es/gps/machineTrace";
        try {
            s1 = HttpSendUtil.sendHttpPost((String)url, (String)"", (String)"", (String)array.toJSONString(), null);
        }
        catch (IOException e) {
            log.error("\u8054\u9002GPS\u5b9e\u65f6\u4f4d\u7f6e\u63a8\u9001\uff1a" + e.getMessage());
        }
        log.error("\u8054\u9002GPS\u5b9e\u65f6\u4f4d\u7f6e\u63a8\u9001\u7ed3\u679c\uff1a" + s1);
        return s1;
    }

    public JSONObject checkData(String result, String url) {
        String code;
        JSONObject dataObj = new JSONObject();
        JSONObject obj = JSON.parseObject((String)result);
        String string = code = obj.get((Object)"code") == null ? "" : obj.get((Object)"code").toString();
        if (StringUtil.isNotEmpty((String)code) && "200".equals(code)) {
            String data;
            String string2 = data = obj.get((Object)"data") == null ? "" : obj.get((Object)"data").toString();
            if (StringUtil.isNotEmpty((String)data)) {
                dataObj = JSON.parseObject((String)data);
            }
        } else {
            String msg = obj.get((Object)"message") == null ? "" : obj.get((Object)"message").toString();
            log.error("error:{} url{}", (Object)("\u83b7\u53d6\u4f5c\u4e1a\u65e5\u5386\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a" + msg), (Object)("\u8c03\u7528\u63a5\u53e3\u5730\u5740\uff1a" + url));
            throw new DataException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff01");
        }
        return dataObj;
    }

    public TransplanterServiceImpl(RedisTemplate redisTemplate, TransplanterMapper transplanterMapper) {
        this.redisTemplate = redisTemplate;
        this.transplanterMapper = transplanterMapper;
    }
}

