/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.shuxi.bean.bo.WaterLevelCorrectBo;
import com.shuxi.bean.bo.WaterLevelDeviceBo;
import com.shuxi.bean.entity.WaterLevelDevice;
import com.shuxi.bean.vo.WaterLevelDeviceVo;
import com.shuxi.bean.vo.WaterLevelVo;
import com.shuxi.mapper.IrrigationMapper;
import com.shuxi.mapper.WaterLevelDeviceMapper;
import com.shuxi.service.MqttClientService;
import com.shuxi.service.WaterLevelDeviceService;
import com.shuxi.util.IdGenerator;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class WaterLevelDeviceServiceImpl
extends ServiceImpl<WaterLevelDeviceMapper, WaterLevelDevice>
implements WaterLevelDeviceService {
    private static final Logger log = LoggerFactory.getLogger(WaterLevelDeviceServiceImpl.class);
    public static final String IS_INSTALL_CONFIG = "water_level_is_install_config";
    private final MqttClientService mqttClientService;
    @Autowired
    private IrrigationMapper irrigationMapper;
    @Autowired
    private WaterLevelDeviceMapper waterLevelDeviceMapper;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public List<WaterLevelDevice> getWaterLevelDeviceInfoList() {
        return this.waterLevelDeviceMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"deleted", (Object)0));
    }

    public WaterLevelDevice getWaterLevelDeviceInfo(String id) {
        return (WaterLevelDevice)this.waterLevelDeviceMapper.selectById((Serializable)((Object)id));
    }

    public int deleteWaterLevelDevice(String id) {
        this.irrigationMapper.deleteHztFieldCtlById(id);
        this.irrigationMapper.deleteIrrigationCtlById(id);
        return this.waterLevelDeviceMapper.deleteByDeviceId(Long.parseLong(id));
    }

    public int updateWaterLevelDevice(WaterLevelDeviceBo entity) {
        entity.setPoleLen(Float.valueOf(305.0f));
        entity.setBallOffset(Float.valueOf(0.0134f));
        this.irrigationMapper.updateByDevId(entity);
        this.waterLevelDeviceMapper.updateByDeviceId(entity);
        this.redisTemplate.opsForHash().put((Object)IS_INSTALL_CONFIG, (Object)entity.getDeviceNo(), (Object)"1");
        this.mqttClientService.mqttSendWaterLevels();
        return 1;
    }

    public List<WaterLevelDeviceVo> getDetailById(String fieldId, String companyId, String id) {
        return this.waterLevelDeviceMapper.getDetailById(fieldId, companyId, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertWaterLevelDevice(WaterLevelDeviceBo bo) {
        bo.setId(Long.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
        bo.setDeviceNo(String.valueOf(bo.getId()));
        bo.setName(bo.getId() + "#\u6c34\u4f4d\u4eea");
        bo.setCreateTime(new Date());
        bo.setPoleLen(Float.valueOf(305.0f));
        bo.setBallOffset(Float.valueOf(0.0134f));
        this.irrigationMapper.insertWaterLevelDevice(bo);
        this.irrigationMapper.insertHztFieldCtl(bo.getFieldId(), bo.getId().longValue(), bo.getCompanyId());
        int row = this.waterLevelDeviceMapper.insert((Object)bo);
        this.redisTemplate.opsForHash().put((Object)IS_INSTALL_CONFIG, (Object)bo.getDeviceNo(), (Object)"1");
        this.mqttClientService.mqttSendWaterLevels();
        return row;
    }

    public List<WaterLevelVo> getWaterLevelInfo(String id, String companyId, int limit) {
        return this.waterLevelDeviceMapper.getWaterLevelInfo(id, companyId, limit);
    }

    public boolean correctWaterLevel(WaterLevelCorrectBo correctBo) {
        WaterLevelDevice device = (WaterLevelDevice)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.waterLevelDeviceMapper).eq(WaterLevelDevice::getCompanyId, (Object)correctBo.getCompanyId())).eq(WaterLevelDevice::getDeviceNo, (Object)correctBo.getDeviceNo())).one();
        Assert.notNull((Object)device, (String)"\u672a\u67e5\u5230\u6c34\u4f4d\u4eea\u7684\u914d\u7f6e\u4fe1\u606f");
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)new LambdaUpdateChainWrapper((BaseMapper)this.waterLevelDeviceMapper).eq(WaterLevelDevice::getId, (Object)device.getId())).set(WaterLevelDevice::getHeightOffset, (Object)((double)device.getHeightOffset().floatValue() + correctBo.getRealHeight() - correctBo.getWaterLevelHeight()))).update();
    }

    public WaterLevelDeviceServiceImpl(MqttClientService mqttClientService) {
        this.mqttClientService = mqttClientService;
    }
}

