/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.shuxi.base.constants.BasicConstants;
import com.shuxi.bean.bo.WaterLevelValveUnionBo;
import com.shuxi.bean.dto.MilldamDto;
import com.shuxi.bean.entity.WaterLevel;
import com.shuxi.bean.entity.WaterLevelValveUnion;
import com.shuxi.bean.entity.WaterLevelValveUnionLog;
import com.shuxi.bean.vo.WaterLevelValveUnionVo;
import com.shuxi.common.component.AsyncBlockWaiter;
import com.shuxi.common.exception.SystemRuntimeException;
import com.shuxi.mapper.MilldamMapper;
import com.shuxi.mapper.WaterLevelMapper;
import com.shuxi.mapper.WaterLevelValveUnionLogMapper;
import com.shuxi.mapper.WaterLevelValveUnionMapper;
import com.shuxi.service.MqttClientService;
import com.shuxi.service.WaterLevelService;
import com.shuxi.util.BeanCopyUtil;
import com.shuxi.util.IdGenerator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class WaterLevelServiceImpl
implements WaterLevelService {
    private static final Logger log = LoggerFactory.getLogger(WaterLevelServiceImpl.class);
    private final WaterLevelMapper waterLevelMapper;
    private final MilldamMapper milldamMapper;
    private final WaterLevelValveUnionMapper waterLevelValveUnionMapper;
    private final WaterLevelValveUnionLogMapper waterLevelValveUnionLogMapper;
    private final MqttClientService mqttClientService;
    private final AsyncBlockWaiter asyncBlockWaiter;

    public Float getWaterLevelHeight(Integer companyId, String deviceNo) {
        WaterLevel waterLevel = (WaterLevel)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.waterLevelMapper).eq(WaterLevel::getCompanyId, (Object)companyId)).eq(WaterLevel::getDeviceNo, (Object)deviceNo)).orderByDesc(WaterLevel::getCreateTime)).last("limit 1")).one();
        if (waterLevel != null && waterLevel.getCreateTime() != null && System.currentTimeMillis() - waterLevel.getCreateTime().getTime() < 30000L) {
            return waterLevel.getCalcHeight();
        }
        MilldamDto milldamDto = this.milldamMapper.selectById(deviceNo);
        Assert.notNull((Object)milldamDto, (String)"\u7528\u8bbe\u5907\u7f16\u7801\u672a\u80fd\u67e5\u5230\u8bbe\u5907\u4fe1\u606f");
        this.mqttClientService.mqttSendWaterLevel(milldamDto.getIdFour());
        try {
            return (Float)this.asyncBlockWaiter.waitReturn(deviceNo, Long.valueOf(5000L));
        }
        catch (AsyncBlockWaiter.DataNotRecvException e) {
            throw new SystemRuntimeException("\u6c34\u4f4d\u67e5\u8be2\u7ed3\u679c\u963b\u585e\u7b49\u5f85\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean addUnionConfig(List<WaterLevelValveUnionBo> waterLevelValveUnionBoList) {
        if (CollectionUtils.isEmpty(waterLevelValveUnionBoList)) {
            return false;
        }
        List noList = waterLevelValveUnionBoList.stream().map(WaterLevelValveUnionBo::getWaterLevelDevNo).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)new LambdaUpdateChainWrapper((BaseMapper)this.waterLevelValveUnionMapper).eq(WaterLevelValveUnion::getCompanyId, (Object)waterLevelValveUnionBoList.get(0).getCompanyId())).in(WaterLevelValveUnion::getWaterLevelDevNo, noList)).remove();
        for (WaterLevelValveUnionBo waterLevelValveUnionBo : waterLevelValveUnionBoList) {
            MilldamDto milldamDtoW = this.milldamMapper.selectById(waterLevelValveUnionBo.getWaterLevelDevNo());
            MilldamDto milldamDtoV = this.milldamMapper.selectById(waterLevelValveUnionBo.getValveDevNo());
            Assert.notNull((Object)milldamDtoW, (String)"\u672a\u67e5\u5230\u6c34\u4f4d\u4eea\u6570\u636e");
            Assert.notNull((Object)milldamDtoV, (String)"\u672a\u67e5\u5230\u9600\u95e8\u6570\u636e");
            WaterLevelValveUnion waterLevelValveUnion = new WaterLevelValveUnion();
            BeanUtils.copyProperties((Object)waterLevelValveUnionBo, (Object)waterLevelValveUnion);
            waterLevelValveUnion.setConfigId(Long.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
            waterLevelValveUnion.setWaterLevelIdFour(milldamDtoW.getIdFour());
            waterLevelValveUnion.setValveIdFour(milldamDtoV.getIdFour());
            waterLevelValveUnion.setCreateTime(LocalDateTime.now());
            this.waterLevelValveUnionMapper.insert((Object)waterLevelValveUnion);
        }
        return true;
    }

    public List<WaterLevelValveUnionVo> getUnionConfig(Integer companyId, String waterLevelDeviceCode) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.waterLevelValveUnionMapper).eq(WaterLevelValveUnion::getCompanyId, (Object)companyId)).eq(WaterLevelValveUnion::getWaterLevelDevNo, (Object)waterLevelDeviceCode)).orderByAsc(WaterLevelValveUnion::getCreateTime)).list();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        List noList = list.stream().flatMap(po -> Stream.of(po.getWaterLevelDevNo(), po.getValveDevNo())).collect(Collectors.toList());
        List milldamDtos = this.milldamMapper.selectByCodeList(noList);
        Map<String, String> nameMap = milldamDtos.stream().collect(Collectors.toMap(MilldamDto::getCode, MilldamDto::getName));
        return BeanCopyUtil.copyListThenDo((List)list, WaterLevelValveUnionVo::new, (po, vo) -> {
            vo.setWaterLevelDevName((String)nameMap.get(po.getWaterLevelDevNo()));
            vo.setValveDevName((String)nameMap.get(po.getValveDevNo()));
        });
    }

    public boolean deleteUnionConfigs(List<Long> configIdLis) {
        return this.waterLevelValveUnionMapper.deleteBatchIds(configIdLis) > 0;
    }

    public boolean unionRun(Integer companyId, String code, float height) {
        String now = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        List waterLevelValveUnions = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)new LambdaQueryChainWrapper((BaseMapper)this.waterLevelValveUnionMapper).eq(WaterLevelValveUnion::getCompanyId, (Object)companyId)).eq(WaterLevelValveUnion::getWaterLevelDevNo, (Object)code)).apply("to_char(start_time, 'YYYY-MM-DD')<={0} and to_char(end_time, 'YYYY-MM-DD')>={0}", new Object[]{now})).orderByAsc(WaterLevelValveUnion::getCreateTime)).list();
        if (CollectionUtils.isEmpty((Collection)waterLevelValveUnions)) {
            log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u5931\u8d25\uff0c\u672a\u627e\u5230\u914d\u7f6e");
        }
        for (WaterLevelValveUnion waterLevelValveUnion : waterLevelValveUnions) {
            if ("gt".equals(waterLevelValveUnion.getOper()) && height > (float)waterLevelValveUnion.getWaterLevelThreshold().intValue()) {
                log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u89e6\u53d1\uff0c\u9ad8\u5ea6{} > \u9608\u503c{}", (Object)Float.valueOf(height), (Object)waterLevelValveUnion.getWaterLevelThreshold());
            } else if ("lt".equals(waterLevelValveUnion.getOper()) && height < (float)waterLevelValveUnion.getWaterLevelThreshold().intValue()) {
                log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u89e6\u53d1\uff0c\u9ad8\u5ea6{} < \u9608\u503c{}", (Object)Float.valueOf(height), (Object)waterLevelValveUnion.getWaterLevelThreshold());
            } else {
                log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u89e6\u53d1\u5931\u8d25\uff0c\u9ad8\u5ea6{}\uff0c\u914d\u7f6eID{}", (Object)Float.valueOf(height), (Object)waterLevelValveUnion.getConfigId());
                break;
            }
            MilldamDto milldamDto = this.milldamMapper.selectById(waterLevelValveUnion.getValveDevNo());
            Assert.notNull((Object)milldamDto, (String)"\u6c34\u4f4d\u4eea\u8054\u52a8\u914d\u7f6e\u7684\u9600\u95e8code\u5f02\u5e38\uff0c\u672a\u627e\u5230\u9600\u95e8\u8bbe\u5907\u4fe1\u606f");
            WaterLevelValveUnionLog waterLevelValveUnionLog = new WaterLevelValveUnionLog();
            waterLevelValveUnionLog.setId(Long.valueOf(IdGenerator.get((IdGenerator.IdBizType)IdGenerator.IdBizType.ID)));
            BeanUtils.copyProperties((Object)waterLevelValveUnion, (Object)waterLevelValveUnionLog);
            waterLevelValveUnionLog.setWaterLevelHeight(Float.valueOf(height));
            waterLevelValveUnionLog.setUnionStatus("doing");
            Integer onOff = milldamDto.getOnoff();
            Integer codeType = milldamDto.getCodeType();
            Integer functionType = 2;
            try {
                if ("open".equalsIgnoreCase(waterLevelValveUnion.getValveAction())) {
                    if (BasicConstants.INTEGER1.equals(onOff)) {
                        log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u4e0d\u6267\u884c\uff0c\u9600\u95e8\u5df2\u662f\u5f00\u72b6\u6001\uff0cconfigId={}, ctl={}", (Object)waterLevelValveUnion.getConfigId(), (Object)milldamDto);
                        break;
                    }
                    this.mqttClientService.mqttSend(waterLevelValveUnion.getValveDevNo(), functionType, "000000", "\u81ea\u52a8\u6267\u884c\u6c34\u4f4d\u4eea\u8054\u52a8\u64cd\u4f5c", companyId.toString());
                } else if ("close".equalsIgnoreCase(waterLevelValveUnion.getValveAction())) {
                    if (BasicConstants.INTEGER0.equals(onOff) && codeType == 8 || BasicConstants.INTEGER2.equals(onOff) && codeType == 7) {
                        log.info("-------------------------- \u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u4e0d\u6267\u884c\uff0c\u9600\u95e8\u5df2\u662f\u5173\u72b6\u6001\uff0cconfigId={}, ctl={}", (Object)waterLevelValveUnion.getConfigId(), (Object)milldamDto);
                        break;
                    }
                    if (codeType == 7) {
                        functionType = 3;
                    }
                    if (codeType == 8) {
                        functionType = 1;
                    }
                    this.mqttClientService.mqttSend(waterLevelValveUnion.getValveDevNo(), functionType, "000000", "\u81ea\u52a8\u6267\u884c\u6c34\u4f4d\u4eea\u8054\u52a8\u64cd\u4f5c", companyId.toString());
                } else {
                    waterLevelValveUnionLog.setUnionStatus("error");
                    waterLevelValveUnionLog.setRemark("valveAction\u914d\u7f6e\u9519\u8bef");
                }
            }
            catch (Exception e) {
                log.error("\u6c34\u4f4d\u4eea\u9600\u95e8\u8054\u52a8\u8c03\u7528\u9600\u95e8\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (Throwable)e);
                waterLevelValveUnionLog.setUnionStatus("error");
                waterLevelValveUnionLog.setRemark("\u8c03\u7528\u9600\u95e8\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
            this.waterLevelValveUnionLogMapper.insert((Object)waterLevelValveUnionLog);
        }
        return true;
    }

    public WaterLevelServiceImpl(WaterLevelMapper waterLevelMapper, MilldamMapper milldamMapper, WaterLevelValveUnionMapper waterLevelValveUnionMapper, WaterLevelValveUnionLogMapper waterLevelValveUnionLogMapper, MqttClientService mqttClientService, AsyncBlockWaiter asyncBlockWaiter) {
        this.waterLevelMapper = waterLevelMapper;
        this.milldamMapper = milldamMapper;
        this.waterLevelValveUnionMapper = waterLevelValveUnionMapper;
        this.waterLevelValveUnionLogMapper = waterLevelValveUnionLogMapper;
        this.mqttClientService = mqttClientService;
        this.asyncBlockWaiter = asyncBlockWaiter;
    }
}

