/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.util;

import com.shuxi.common.exception.SystemRuntimeException;
import com.shuxi.util.IdGenerator;
import java.util.HashMap;
import java.util.Map;

public class IdGenerator {
    private static final Map<String, IdGenerator> GENERATOR_MAP = new HashMap();
    private static final long BASE_TIMESTAMP = 1724131597761L;
    private final long datacenterId;
    private long sequence = 0L;
    private long preTimestamp = -1L;

    public static synchronized long get(IdBizType idBizType) {
        String bizType = idBizType.toString();
        GENERATOR_MAP.putIfAbsent(bizType, new IdGenerator(0L));
        return ((IdGenerator)GENERATOR_MAP.get(bizType)).nextId(idBizType);
    }

    private IdGenerator(long datacenterId) {
        this.datacenterId = datacenterId;
    }

    private synchronized long nextId(IdBizType idBizType) {
        long timestamp = this.currTimeGen(idBizType.timeDepressLen);
        if (timestamp < this.preTimestamp) {
            throw new SystemRuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.preTimestamp - timestamp << idBizType.timeDepressLen));
        }
        if (this.preTimestamp == timestamp) {
            long sequenceMask = -1L << (int)idBizType.sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
            this.sequence = this.sequence + 1L & sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.preTimestamp, idBizType.timeDepressLen);
            }
        } else {
            this.sequence = 0L;
        }
        this.preTimestamp = timestamp;
        long time = timestamp - (1724131597761L >> idBizType.timeDepressLen);
        return time << (int)(idBizType.datacenterIdBits + idBizType.sequenceBits) | this.datacenterId << (int)idBizType.sequenceBits | this.sequence;
    }

    private long tilNextMillis(long preTimestamp, int timeDepressLen) {
        long timestamp;
        int count = 0;
        while ((timestamp = this.currTimeGen(timeDepressLen)) <= preTimestamp && count++ < 10) {
            try {
                Thread.sleep(1L << timeDepressLen);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (count > 10) {
            throw new SystemRuntimeException("\u963b\u585e\u5230\u4e0b\u4e00\u4e2a\u6beb\u79d2\u5931\u8d25");
        }
        return timestamp;
    }

    private long currTimeGen(int timeDepressLen) {
        return System.currentTimeMillis() >> timeDepressLen;
    }
}

