/*
 * Decompiled with CFR 0.152.
 */
package com.shuxi.util;

import com.shuxi.util.JsonUtil;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class XSSEscape {
    private static final Logger log = LoggerFactory.getLogger(XSSEscape.class);
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.\\.\\|\\.\\./|~/|~\\|[<]|>|\"|[*]|[|]|[?]", 2);
    private static InputStream inputStream;
    private static Policy policy;
    private static Policy emptyPolicy;
    private static Policy imgOnlyBase64Policy;

    public static String escape(String character) {
        try {
            AntiSamy antiSamy = new AntiSamy();
            String str = character.replaceAll("&quot;", "\"");
            str = str.replaceAll("&amp;", "&");
            str = str.replaceAll("&lt;", "<");
            str = str.replaceAll("&gt;", ">");
            CleanResults scan = antiSamy.scan(str, policy);
            str = scan.getCleanHTML();
            return str;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static String escapeImgOnlyBase64(String character) {
        try {
            AntiSamy antiSamy = new AntiSamy();
            String str = character.replaceAll("&quot;", "\"");
            str = str.replaceAll("&amp;", "&");
            str = str.replaceAll("&lt;", "<");
            str = str.replaceAll("&gt;", ">");
            CleanResults scan = antiSamy.scan(str, imgOnlyBase64Policy);
            str = scan.getCleanHTML();
            return str;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
            return null;
        }
    }

    public static <T> T escapeObj(T character) {
        try {
            return (T)JsonUtil.getJsonToBean((String)XSSEscape.escapeEmpty((String)character.toString()), character.getClass());
        }
        catch (Exception exception) {
            return character;
        }
    }

    public static String escapeEmpty(String character) {
        try {
            AntiSamy antiSamy = new AntiSamy();
            CleanResults scan = antiSamy.scan(character, emptyPolicy);
            return scan.getCleanHTML();
        }
        catch (Exception exception) {
            return character;
        }
    }

    public static String escapePath(String path) {
        Matcher matcher = PATH_PATTERN.matcher(path);
        return XSSEscape.escapeEmpty((String)matcher.replaceAll("").replaceAll("\\.\\.", ""));
    }

    static {
        try {
            inputStream = XSSEscape.class.getClassLoader().getResourceAsStream("antisamy-ebay.xml");
            policy = Policy.getInstance((InputStream)inputStream);
            inputStream.close();
            inputStream = XSSEscape.class.getClassLoader().getResourceAsStream("antisamy-ebay-imgonlybase64.xml");
            imgOnlyBase64Policy = Policy.getInstance((InputStream)inputStream);
            inputStream.close();
            inputStream = XSSEscape.class.getClassLoader().getResourceAsStream("antisamy-empty.xml");
            emptyPolicy = Policy.getInstance((InputStream)inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

